/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupPolicy;
import java.io.IOException;
import java.util.List;

public class BaseBackupPolicy
implements JsonSerializable<BaseBackupPolicy> {
    private String objectType = "BaseBackupPolicy";
    private List<String> datasourceTypes;

    public String objectType() {
        return this.objectType;
    }

    public List<String> datasourceTypes() {
        return this.datasourceTypes;
    }

    public BaseBackupPolicy withDatasourceTypes(List<String> datasourceTypes) {
        this.datasourceTypes = datasourceTypes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("datasourceTypes", this.datasourceTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static BaseBackupPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (BaseBackupPolicy)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                BaseBackupPolicy baseBackupPolicy;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("objectType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("BackupPolicy".equals(discriminatorValue)) {
                    baseBackupPolicy = BackupPolicy.fromJson(readerToUse.reset());
                    return baseBackupPolicy;
                }
                baseBackupPolicy = BaseBackupPolicy.fromJsonKnownDiscriminator(readerToUse.reset());
                return baseBackupPolicy;
            }
        });
    }

    static BaseBackupPolicy fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (BaseBackupPolicy)jsonReader.readObject(reader -> {
            BaseBackupPolicy deserializedBaseBackupPolicy = new BaseBackupPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("datasourceTypes".equals(fieldName)) {
                    List datasourceTypes;
                    deserializedBaseBackupPolicy.datasourceTypes = datasourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedBaseBackupPolicy.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBaseBackupPolicy;
        });
    }
}

