/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRecoveryPointBasedRestoreRequest;
import com.azure.resourcemanager.dataprotection.models.IdentityDetails;
import com.azure.resourcemanager.dataprotection.models.RehydrationPriority;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetInfoBase;
import com.azure.resourcemanager.dataprotection.models.SourceDataStoreType;
import java.io.IOException;
import java.util.List;

public final class AzureBackupRestoreWithRehydrationRequest
extends AzureBackupRecoveryPointBasedRestoreRequest {
    private String objectType = "AzureBackupRestoreWithRehydrationRequest";
    private RehydrationPriority rehydrationPriority;
    private String rehydrationRetentionDuration;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public RehydrationPriority rehydrationPriority() {
        return this.rehydrationPriority;
    }

    public AzureBackupRestoreWithRehydrationRequest withRehydrationPriority(RehydrationPriority rehydrationPriority) {
        this.rehydrationPriority = rehydrationPriority;
        return this;
    }

    public String rehydrationRetentionDuration() {
        return this.rehydrationRetentionDuration;
    }

    public AzureBackupRestoreWithRehydrationRequest withRehydrationRetentionDuration(String rehydrationRetentionDuration) {
        this.rehydrationRetentionDuration = rehydrationRetentionDuration;
        return this;
    }

    @Override
    public AzureBackupRestoreWithRehydrationRequest withRecoveryPointId(String recoveryPointId) {
        super.withRecoveryPointId(recoveryPointId);
        return this;
    }

    @Override
    public AzureBackupRestoreWithRehydrationRequest withRestoreTargetInfo(RestoreTargetInfoBase restoreTargetInfo) {
        super.withRestoreTargetInfo(restoreTargetInfo);
        return this;
    }

    @Override
    public AzureBackupRestoreWithRehydrationRequest withSourceDataStoreType(SourceDataStoreType sourceDataStoreType) {
        super.withSourceDataStoreType(sourceDataStoreType);
        return this;
    }

    @Override
    public AzureBackupRestoreWithRehydrationRequest withSourceResourceId(String sourceResourceId) {
        super.withSourceResourceId(sourceResourceId);
        return this;
    }

    @Override
    public AzureBackupRestoreWithRehydrationRequest withResourceGuardOperationRequests(List<String> resourceGuardOperationRequests) {
        super.withResourceGuardOperationRequests((List)resourceGuardOperationRequests);
        return this;
    }

    @Override
    public AzureBackupRestoreWithRehydrationRequest withIdentityDetails(IdentityDetails identityDetails) {
        super.withIdentityDetails(identityDetails);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("restoreTargetInfo", (JsonSerializable)this.restoreTargetInfo());
        jsonWriter.writeStringField("sourceDataStoreType", this.sourceDataStoreType() == null ? null : this.sourceDataStoreType().toString());
        jsonWriter.writeStringField("recoveryPointId", this.recoveryPointId());
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId());
        jsonWriter.writeArrayField("resourceGuardOperationRequests", this.resourceGuardOperationRequests(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identityDetails", (JsonSerializable)this.identityDetails());
        jsonWriter.writeStringField("rehydrationPriority", this.rehydrationPriority == null ? null : this.rehydrationPriority.toString());
        jsonWriter.writeStringField("rehydrationRetentionDuration", this.rehydrationRetentionDuration);
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupRestoreWithRehydrationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupRestoreWithRehydrationRequest)jsonReader.readObject(reader -> {
            AzureBackupRestoreWithRehydrationRequest deserializedAzureBackupRestoreWithRehydrationRequest = new AzureBackupRestoreWithRehydrationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restoreTargetInfo".equals(fieldName)) {
                    deserializedAzureBackupRestoreWithRehydrationRequest.withRestoreTargetInfo(RestoreTargetInfoBase.fromJson(reader));
                    continue;
                }
                if ("sourceDataStoreType".equals(fieldName)) {
                    deserializedAzureBackupRestoreWithRehydrationRequest.withSourceDataStoreType(SourceDataStoreType.fromString(reader.getString()));
                    continue;
                }
                if ("recoveryPointId".equals(fieldName)) {
                    deserializedAzureBackupRestoreWithRehydrationRequest.withRecoveryPointId(reader.getString());
                    continue;
                }
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedAzureBackupRestoreWithRehydrationRequest.withSourceResourceId(reader.getString());
                    continue;
                }
                if ("resourceGuardOperationRequests".equals(fieldName)) {
                    List resourceGuardOperationRequests = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureBackupRestoreWithRehydrationRequest.withResourceGuardOperationRequests(resourceGuardOperationRequests);
                    continue;
                }
                if ("identityDetails".equals(fieldName)) {
                    deserializedAzureBackupRestoreWithRehydrationRequest.withIdentityDetails(IdentityDetails.fromJson(reader));
                    continue;
                }
                if ("rehydrationPriority".equals(fieldName)) {
                    deserializedAzureBackupRestoreWithRehydrationRequest.rehydrationPriority = RehydrationPriority.fromString(reader.getString());
                    continue;
                }
                if ("rehydrationRetentionDuration".equals(fieldName)) {
                    deserializedAzureBackupRestoreWithRehydrationRequest.rehydrationRetentionDuration = reader.getString();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAzureBackupRestoreWithRehydrationRequest.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupRestoreWithRehydrationRequest;
        });
    }
}

