/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRecoveryPointBasedRestoreRequest;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRecoveryTimeBasedRestoreRequest;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRestoreWithRehydrationRequest;
import com.azure.resourcemanager.dataprotection.models.IdentityDetails;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetInfoBase;
import com.azure.resourcemanager.dataprotection.models.SourceDataStoreType;
import java.io.IOException;
import java.util.List;

public class AzureBackupRestoreRequest
implements JsonSerializable<AzureBackupRestoreRequest> {
    private String objectType = "AzureBackupRestoreRequest";
    private RestoreTargetInfoBase restoreTargetInfo;
    private SourceDataStoreType sourceDataStoreType;
    private String sourceResourceId;
    private List<String> resourceGuardOperationRequests;
    private IdentityDetails identityDetails;

    public String objectType() {
        return this.objectType;
    }

    public RestoreTargetInfoBase restoreTargetInfo() {
        return this.restoreTargetInfo;
    }

    public AzureBackupRestoreRequest withRestoreTargetInfo(RestoreTargetInfoBase restoreTargetInfo) {
        this.restoreTargetInfo = restoreTargetInfo;
        return this;
    }

    public SourceDataStoreType sourceDataStoreType() {
        return this.sourceDataStoreType;
    }

    public AzureBackupRestoreRequest withSourceDataStoreType(SourceDataStoreType sourceDataStoreType) {
        this.sourceDataStoreType = sourceDataStoreType;
        return this;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public AzureBackupRestoreRequest withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    public List<String> resourceGuardOperationRequests() {
        return this.resourceGuardOperationRequests;
    }

    public AzureBackupRestoreRequest withResourceGuardOperationRequests(List<String> resourceGuardOperationRequests) {
        this.resourceGuardOperationRequests = resourceGuardOperationRequests;
        return this;
    }

    public IdentityDetails identityDetails() {
        return this.identityDetails;
    }

    public AzureBackupRestoreRequest withIdentityDetails(IdentityDetails identityDetails) {
        this.identityDetails = identityDetails;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("restoreTargetInfo", (JsonSerializable)this.restoreTargetInfo);
        jsonWriter.writeStringField("sourceDataStoreType", this.sourceDataStoreType == null ? null : this.sourceDataStoreType.toString());
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        jsonWriter.writeArrayField("resourceGuardOperationRequests", this.resourceGuardOperationRequests, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identityDetails", (JsonSerializable)this.identityDetails);
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupRestoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupRestoreRequest)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                AzureBackupRestoreRequest azureBackupRestoreRequest;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("objectType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureBackupRecoveryPointBasedRestoreRequest".equals(discriminatorValue)) {
                    azureBackupRestoreRequest = AzureBackupRecoveryPointBasedRestoreRequest.fromJsonKnownDiscriminator(readerToUse.reset());
                    return azureBackupRestoreRequest;
                }
                if ("AzureBackupRestoreWithRehydrationRequest".equals(discriminatorValue)) {
                    azureBackupRestoreRequest = AzureBackupRestoreWithRehydrationRequest.fromJson(readerToUse.reset());
                    return azureBackupRestoreRequest;
                }
                if ("AzureBackupRecoveryTimeBasedRestoreRequest".equals(discriminatorValue)) {
                    azureBackupRestoreRequest = AzureBackupRecoveryTimeBasedRestoreRequest.fromJson(readerToUse.reset());
                    return azureBackupRestoreRequest;
                }
                azureBackupRestoreRequest = AzureBackupRestoreRequest.fromJsonKnownDiscriminator(readerToUse.reset());
                return azureBackupRestoreRequest;
            }
        });
    }

    static AzureBackupRestoreRequest fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (AzureBackupRestoreRequest)jsonReader.readObject(reader -> {
            AzureBackupRestoreRequest deserializedAzureBackupRestoreRequest = new AzureBackupRestoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restoreTargetInfo".equals(fieldName)) {
                    deserializedAzureBackupRestoreRequest.restoreTargetInfo = RestoreTargetInfoBase.fromJson(reader);
                    continue;
                }
                if ("sourceDataStoreType".equals(fieldName)) {
                    deserializedAzureBackupRestoreRequest.sourceDataStoreType = SourceDataStoreType.fromString(reader.getString());
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAzureBackupRestoreRequest.objectType = reader.getString();
                    continue;
                }
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedAzureBackupRestoreRequest.sourceResourceId = reader.getString();
                    continue;
                }
                if ("resourceGuardOperationRequests".equals(fieldName)) {
                    List resourceGuardOperationRequests;
                    deserializedAzureBackupRestoreRequest.resourceGuardOperationRequests = resourceGuardOperationRequests = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("identityDetails".equals(fieldName)) {
                    deserializedAzureBackupRestoreRequest.identityDetails = IdentityDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupRestoreRequest;
        });
    }
}

