/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRecoveryPoint;
import com.azure.resourcemanager.dataprotection.models.RecoveryPointCompletionState;
import com.azure.resourcemanager.dataprotection.models.RecoveryPointDataStoreDetails;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class AzureBackupDiscreteRecoveryPoint
extends AzureBackupRecoveryPoint {
    private String objectType = "AzureBackupDiscreteRecoveryPoint";
    private String friendlyName;
    private List<RecoveryPointDataStoreDetails> recoveryPointDataStoresDetails;
    private OffsetDateTime recoveryPointTime;
    private String policyName;
    private String policyVersion;
    private String recoveryPointId;
    private String recoveryPointType;
    private String retentionTagName;
    private String retentionTagVersion;
    private OffsetDateTime expiryTime;
    private RecoveryPointCompletionState recoveryPointState;

    private AzureBackupDiscreteRecoveryPoint() {
    }

    @Override
    public String objectType() {
        return this.objectType;
    }

    public String friendlyName() {
        return this.friendlyName;
    }

    public List<RecoveryPointDataStoreDetails> recoveryPointDataStoresDetails() {
        return this.recoveryPointDataStoresDetails;
    }

    public OffsetDateTime recoveryPointTime() {
        return this.recoveryPointTime;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyVersion() {
        return this.policyVersion;
    }

    public String recoveryPointId() {
        return this.recoveryPointId;
    }

    public String recoveryPointType() {
        return this.recoveryPointType;
    }

    public String retentionTagName() {
        return this.retentionTagName;
    }

    public String retentionTagVersion() {
        return this.retentionTagVersion;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public RecoveryPointCompletionState recoveryPointState() {
        return this.recoveryPointState;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recoveryPointTime", this.recoveryPointTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.recoveryPointTime));
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("friendlyName", this.friendlyName);
        jsonWriter.writeArrayField("recoveryPointDataStoresDetails", this.recoveryPointDataStoresDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("policyName", this.policyName);
        jsonWriter.writeStringField("policyVersion", this.policyVersion);
        jsonWriter.writeStringField("recoveryPointId", this.recoveryPointId);
        jsonWriter.writeStringField("recoveryPointType", this.recoveryPointType);
        jsonWriter.writeStringField("retentionTagName", this.retentionTagName);
        jsonWriter.writeStringField("retentionTagVersion", this.retentionTagVersion);
        jsonWriter.writeStringField("recoveryPointState", this.recoveryPointState == null ? null : this.recoveryPointState.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupDiscreteRecoveryPoint fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupDiscreteRecoveryPoint)jsonReader.readObject(reader -> {
            AzureBackupDiscreteRecoveryPoint deserializedAzureBackupDiscreteRecoveryPoint = new AzureBackupDiscreteRecoveryPoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recoveryPointTime".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.recoveryPointTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.objectType = reader.getString();
                    continue;
                }
                if ("friendlyName".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.friendlyName = reader.getString();
                    continue;
                }
                if ("recoveryPointDataStoresDetails".equals(fieldName)) {
                    List recoveryPointDataStoresDetails;
                    deserializedAzureBackupDiscreteRecoveryPoint.recoveryPointDataStoresDetails = recoveryPointDataStoresDetails = reader.readArray(reader1 -> RecoveryPointDataStoreDetails.fromJson(reader1));
                    continue;
                }
                if ("policyName".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.policyName = reader.getString();
                    continue;
                }
                if ("policyVersion".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.policyVersion = reader.getString();
                    continue;
                }
                if ("recoveryPointId".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.recoveryPointId = reader.getString();
                    continue;
                }
                if ("recoveryPointType".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.recoveryPointType = reader.getString();
                    continue;
                }
                if ("retentionTagName".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.retentionTagName = reader.getString();
                    continue;
                }
                if ("retentionTagVersion".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.retentionTagVersion = reader.getString();
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recoveryPointState".equals(fieldName)) {
                    deserializedAzureBackupDiscreteRecoveryPoint.recoveryPointState = RecoveryPointCompletionState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupDiscreteRecoveryPoint;
        });
    }
}

