/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.FetchSecondaryRecoveryPointsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupRecoveryPointResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.models.AzureBackupRecoveryPointResourceList;
import com.azure.resourcemanager.dataprotection.models.FetchSecondaryRPsRequestParameters;
import reactor.core.publisher.Mono;

public final class FetchSecondaryRecoveryPointsClientImpl
implements FetchSecondaryRecoveryPointsClient {
    private final FetchSecondaryRecoveryPointsService service;
    private final DataProtectionManagementClientImpl client;

    FetchSecondaryRecoveryPointsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (FetchSecondaryRecoveryPointsService)RestProxy.create(FetchSecondaryRecoveryPointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureBackupRecoveryPointResourceInner>> listSinglePageAsync(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters, String filter, String skipToken) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, location, filter, skipToken, "application/json", parameters, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupRecoveryPointResourceList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureBackupRecoveryPointResourceInner> listAsync(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters, String filter, String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, location, parameters, filter, skipToken));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureBackupRecoveryPointResourceInner> listAsync(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters) {
        String filter = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, location, parameters, filter, skipToken));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AzureBackupRecoveryPointResourceInner> listSinglePage(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters, String filter, String skipToken) {
        String accept = "application/json";
        Response<AzureBackupRecoveryPointResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, location, filter, skipToken, "application/json", parameters, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupRecoveryPointResourceList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AzureBackupRecoveryPointResourceInner> listSinglePage(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters, String filter, String skipToken, Context context) {
        String accept = "application/json";
        Response<AzureBackupRecoveryPointResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, location, filter, skipToken, "application/json", parameters, context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupRecoveryPointResourceList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureBackupRecoveryPointResourceInner> list(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters) {
        String filter = null;
        String skipToken = null;
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, location, parameters, filter, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureBackupRecoveryPointResourceInner> list(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters, String filter, String skipToken, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, location, parameters, filter, skipToken, context));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientFetchSecondaryRecoveryPoints")
    public static interface FetchSecondaryRecoveryPointsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchSecondaryRecoveryPoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureBackupRecoveryPointResourceList>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="location") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") FetchSecondaryRPsRequestParameters var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchSecondaryRecoveryPoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AzureBackupRecoveryPointResourceList> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="location") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") FetchSecondaryRPsRequestParameters var9, Context var10);
    }
}

