/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.DeletedBackupInstancesClient;
import com.azure.resourcemanager.dataprotection.fluent.models.DeletedBackupInstanceResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DeletedBackupInstanceResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.DeletedBackupInstanceResource;
import com.azure.resourcemanager.dataprotection.models.DeletedBackupInstances;

public final class DeletedBackupInstancesImpl
implements DeletedBackupInstances {
    private static final ClientLogger LOGGER = new ClientLogger(DeletedBackupInstancesImpl.class);
    private final DeletedBackupInstancesClient innerClient;
    private final DataProtectionManager serviceManager;

    public DeletedBackupInstancesImpl(DeletedBackupInstancesClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DeletedBackupInstanceResource> getWithResponse(String resourceGroupName, String vaultName, String backupInstanceName, Context context) {
        Response<DeletedBackupInstanceResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, backupInstanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeletedBackupInstanceResourceImpl((DeletedBackupInstanceResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DeletedBackupInstanceResource get(String resourceGroupName, String vaultName, String backupInstanceName) {
        DeletedBackupInstanceResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, backupInstanceName);
        if (inner != null) {
            return new DeletedBackupInstanceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DeletedBackupInstanceResource> list(String resourceGroupName, String vaultName) {
        PagedIterable<DeletedBackupInstanceResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeletedBackupInstanceResourceImpl((DeletedBackupInstanceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DeletedBackupInstanceResource> list(String resourceGroupName, String vaultName, Context context) {
        PagedIterable<DeletedBackupInstanceResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeletedBackupInstanceResourceImpl((DeletedBackupInstanceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public void undelete(String resourceGroupName, String vaultName, String backupInstanceName) {
        this.serviceClient().undelete(resourceGroupName, vaultName, backupInstanceName);
    }

    @Override
    public void undelete(String resourceGroupName, String vaultName, String backupInstanceName, Context context) {
        this.serviceClient().undelete(resourceGroupName, vaultName, backupInstanceName, context);
    }

    private DeletedBackupInstancesClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

