/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.DataProtectionsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.FeatureValidationResponseBaseInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.models.FeatureValidationRequestBase;
import reactor.core.publisher.Mono;

public final class DataProtectionsClientImpl
implements DataProtectionsClient {
    private final DataProtectionsService service;
    private final DataProtectionManagementClientImpl client;

    DataProtectionsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (DataProtectionsService)RestProxy.create(DataProtectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FeatureValidationResponseBaseInner>> checkFeatureSupportWithResponseAsync(String location, FeatureValidationRequestBase parameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkFeatureSupport(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FeatureValidationResponseBaseInner> checkFeatureSupportAsync(String location, FeatureValidationRequestBase parameters) {
        return this.checkFeatureSupportWithResponseAsync(location, parameters).flatMap(res -> Mono.justOrEmpty((Object)((FeatureValidationResponseBaseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FeatureValidationResponseBaseInner> checkFeatureSupportWithResponse(String location, FeatureValidationRequestBase parameters, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.checkFeatureSupportSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, "application/json", "application/json", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FeatureValidationResponseBaseInner checkFeatureSupport(String location, FeatureValidationRequestBase parameters) {
        return (FeatureValidationResponseBaseInner)this.checkFeatureSupportWithResponse(location, parameters, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientDataProtections")
    public static interface DataProtectionsService {
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/locations/{location}/checkFeatureSupport")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureValidationResponseBaseInner>> checkFeatureSupport(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") FeatureValidationRequestBase var7, Context var8);

        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/locations/{location}/checkFeatureSupport")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<FeatureValidationResponseBaseInner> checkFeatureSupportSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") FeatureValidationRequestBase var7, Context var8);
    }
}

