/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupVaultResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.BackupVault;
import com.azure.resourcemanager.dataprotection.models.BackupVaultResource;
import com.azure.resourcemanager.dataprotection.models.DppIdentityDetails;
import com.azure.resourcemanager.dataprotection.models.PatchBackupVaultInput;
import com.azure.resourcemanager.dataprotection.models.PatchResourceRequestInput;
import java.util.Collections;
import java.util.Map;

public final class BackupVaultResourceImpl
implements BackupVaultResource,
BackupVaultResource.Definition,
BackupVaultResource.Update {
    private BackupVaultResourceInner innerObject;
    private final DataProtectionManager serviceManager;
    private String resourceGroupName;
    private String vaultName;
    private PatchResourceRequestInput updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public BackupVault properties() {
        return this.innerModel().properties();
    }

    @Override
    public DppIdentityDetails identity() {
        return this.innerModel().identity();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BackupVaultResourceInner innerModel() {
        return this.innerObject;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupVaultResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public BackupVaultResource create() {
        this.innerObject = this.serviceManager.serviceClient().getBackupVaults().createOrUpdate(this.resourceGroupName, this.vaultName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BackupVaultResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackupVaults().createOrUpdate(this.resourceGroupName, this.vaultName, this.innerModel(), context);
        return this;
    }

    BackupVaultResourceImpl(String name, DataProtectionManager serviceManager) {
        this.innerObject = new BackupVaultResourceInner();
        this.serviceManager = serviceManager;
        this.vaultName = name;
    }

    @Override
    public BackupVaultResourceImpl update() {
        this.updateParameters = new PatchResourceRequestInput();
        return this;
    }

    @Override
    public BackupVaultResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getBackupVaults().update(this.resourceGroupName, this.vaultName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public BackupVaultResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackupVaults().update(this.resourceGroupName, this.vaultName, this.updateParameters, context);
        return this;
    }

    BackupVaultResourceImpl(BackupVaultResourceInner innerObject, DataProtectionManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.vaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupVaults");
    }

    @Override
    public BackupVaultResource refresh() {
        this.innerObject = (BackupVaultResourceInner)((Object)this.serviceManager.serviceClient().getBackupVaults().getByResourceGroupWithResponse(this.resourceGroupName, this.vaultName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BackupVaultResource refresh(Context context) {
        this.innerObject = (BackupVaultResourceInner)((Object)this.serviceManager.serviceClient().getBackupVaults().getByResourceGroupWithResponse(this.resourceGroupName, this.vaultName, context).getValue());
        return this;
    }

    @Override
    public BackupVaultResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public BackupVaultResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public BackupVaultResourceImpl withProperties(BackupVault properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public BackupVaultResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public BackupVaultResourceImpl withIdentity(DppIdentityDetails identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public BackupVaultResourceImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public BackupVaultResourceImpl withProperties(PatchBackupVaultInput properties) {
        this.updateParameters.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

