/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.BackupInstancesExtensionRoutingsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupInstanceResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.BackupInstanceResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.BackupInstanceResource;
import com.azure.resourcemanager.dataprotection.models.BackupInstancesExtensionRoutings;

public final class BackupInstancesExtensionRoutingsImpl
implements BackupInstancesExtensionRoutings {
    private static final ClientLogger LOGGER = new ClientLogger(BackupInstancesExtensionRoutingsImpl.class);
    private final BackupInstancesExtensionRoutingsClient innerClient;
    private final DataProtectionManager serviceManager;

    public BackupInstancesExtensionRoutingsImpl(BackupInstancesExtensionRoutingsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BackupInstanceResource> list(String resourceId) {
        PagedIterable<BackupInstanceResourceInner> inner = this.serviceClient().list(resourceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupInstanceResourceImpl((BackupInstanceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupInstanceResource> list(String resourceId, Context context) {
        PagedIterable<BackupInstanceResourceInner> inner = this.serviceClient().list(resourceId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupInstanceResourceImpl((BackupInstanceResourceInner)((Object)inner1), this.manager()));
    }

    private BackupInstancesExtensionRoutingsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

