/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.ResourceGuard;
import java.io.IOException;
import java.util.Map;

public final class ResourceGuardResourceInner
extends Resource {
    private ResourceGuard properties;
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ResourceGuard properties() {
        return this.properties;
    }

    public ResourceGuardResourceInner withProperties(ResourceGuard properties) {
        this.properties = properties;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public ResourceGuardResourceInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ResourceGuardResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ResourceGuardResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeStringField("eTag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static ResourceGuardResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGuardResourceInner)((Object)jsonReader.readObject(reader -> {
            ResourceGuardResourceInner deserializedResourceGuardResourceInner = new ResourceGuardResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceGuardResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceGuardResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceGuardResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedResourceGuardResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedResourceGuardResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedResourceGuardResourceInner.properties = ResourceGuard.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedResourceGuardResourceInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedResourceGuardResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGuardResourceInner;
        }));
    }
}

