/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.fluent.DataProtectionManagementClient;
import com.azure.resourcemanager.dataprotection.implementation.BackupInstancesExtensionRoutingsImpl;
import com.azure.resourcemanager.dataprotection.implementation.BackupInstancesImpl;
import com.azure.resourcemanager.dataprotection.implementation.BackupPoliciesImpl;
import com.azure.resourcemanager.dataprotection.implementation.BackupVaultOperationResultsImpl;
import com.azure.resourcemanager.dataprotection.implementation.BackupVaultsImpl;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientBuilder;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionOperationsImpl;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionsImpl;
import com.azure.resourcemanager.dataprotection.implementation.DeletedBackupInstancesImpl;
import com.azure.resourcemanager.dataprotection.implementation.DppResourceGuardProxiesImpl;
import com.azure.resourcemanager.dataprotection.implementation.ExportJobsImpl;
import com.azure.resourcemanager.dataprotection.implementation.ExportJobsOperationResultsImpl;
import com.azure.resourcemanager.dataprotection.implementation.FetchCrossRegionRestoreJobsImpl;
import com.azure.resourcemanager.dataprotection.implementation.FetchCrossRegionRestoreJobsOperationsImpl;
import com.azure.resourcemanager.dataprotection.implementation.FetchSecondaryRecoveryPointsImpl;
import com.azure.resourcemanager.dataprotection.implementation.JobsImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationResultsImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationStatusBackupVaultContextsImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationStatusImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationStatusResourceGroupContextsImpl;
import com.azure.resourcemanager.dataprotection.implementation.RecoveryPointsImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceGuardsImpl;
import com.azure.resourcemanager.dataprotection.implementation.RestorableTimeRangesImpl;
import com.azure.resourcemanager.dataprotection.models.BackupInstances;
import com.azure.resourcemanager.dataprotection.models.BackupInstancesExtensionRoutings;
import com.azure.resourcemanager.dataprotection.models.BackupPolicies;
import com.azure.resourcemanager.dataprotection.models.BackupVaultOperationResults;
import com.azure.resourcemanager.dataprotection.models.BackupVaults;
import com.azure.resourcemanager.dataprotection.models.DataProtectionOperations;
import com.azure.resourcemanager.dataprotection.models.DataProtections;
import com.azure.resourcemanager.dataprotection.models.DeletedBackupInstances;
import com.azure.resourcemanager.dataprotection.models.DppResourceGuardProxies;
import com.azure.resourcemanager.dataprotection.models.ExportJobs;
import com.azure.resourcemanager.dataprotection.models.ExportJobsOperationResults;
import com.azure.resourcemanager.dataprotection.models.FetchCrossRegionRestoreJobs;
import com.azure.resourcemanager.dataprotection.models.FetchCrossRegionRestoreJobsOperations;
import com.azure.resourcemanager.dataprotection.models.FetchSecondaryRecoveryPoints;
import com.azure.resourcemanager.dataprotection.models.Jobs;
import com.azure.resourcemanager.dataprotection.models.OperationResults;
import com.azure.resourcemanager.dataprotection.models.OperationStatus;
import com.azure.resourcemanager.dataprotection.models.OperationStatusBackupVaultContexts;
import com.azure.resourcemanager.dataprotection.models.OperationStatusResourceGroupContexts;
import com.azure.resourcemanager.dataprotection.models.RecoveryPoints;
import com.azure.resourcemanager.dataprotection.models.ResourceGuards;
import com.azure.resourcemanager.dataprotection.models.RestorableTimeRanges;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DataProtectionManager {
    private DataProtectionOperations dataProtectionOperations;
    private BackupInstances backupInstances;
    private BackupVaultOperationResults backupVaultOperationResults;
    private ResourceGuards resourceGuards;
    private BackupVaults backupVaults;
    private OperationStatusBackupVaultContexts operationStatusBackupVaultContexts;
    private ExportJobs exportJobs;
    private ExportJobsOperationResults exportJobsOperationResults;
    private BackupPolicies backupPolicies;
    private RestorableTimeRanges restorableTimeRanges;
    private RecoveryPoints recoveryPoints;
    private Jobs jobs;
    private DeletedBackupInstances deletedBackupInstances;
    private DppResourceGuardProxies dppResourceGuardProxies;
    private OperationResults operationResults;
    private OperationStatus operationStatus;
    private OperationStatusResourceGroupContexts operationStatusResourceGroupContexts;
    private DataProtections dataProtections;
    private FetchSecondaryRecoveryPoints fetchSecondaryRecoveryPoints;
    private FetchCrossRegionRestoreJobs fetchCrossRegionRestoreJobs;
    private FetchCrossRegionRestoreJobsOperations fetchCrossRegionRestoreJobsOperations;
    private BackupInstancesExtensionRoutings backupInstancesExtensionRoutings;
    private final DataProtectionManagementClient clientObject;

    private DataProtectionManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new DataProtectionManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static DataProtectionManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return DataProtectionManager.configure().authenticate(credential, profile);
    }

    public static DataProtectionManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new DataProtectionManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public DataProtectionOperations dataProtectionOperations() {
        if (this.dataProtectionOperations == null) {
            this.dataProtectionOperations = new DataProtectionOperationsImpl(this.clientObject.getDataProtectionOperations(), this);
        }
        return this.dataProtectionOperations;
    }

    public BackupInstances backupInstances() {
        if (this.backupInstances == null) {
            this.backupInstances = new BackupInstancesImpl(this.clientObject.getBackupInstances(), this);
        }
        return this.backupInstances;
    }

    public BackupVaultOperationResults backupVaultOperationResults() {
        if (this.backupVaultOperationResults == null) {
            this.backupVaultOperationResults = new BackupVaultOperationResultsImpl(this.clientObject.getBackupVaultOperationResults(), this);
        }
        return this.backupVaultOperationResults;
    }

    public ResourceGuards resourceGuards() {
        if (this.resourceGuards == null) {
            this.resourceGuards = new ResourceGuardsImpl(this.clientObject.getResourceGuards(), this);
        }
        return this.resourceGuards;
    }

    public BackupVaults backupVaults() {
        if (this.backupVaults == null) {
            this.backupVaults = new BackupVaultsImpl(this.clientObject.getBackupVaults(), this);
        }
        return this.backupVaults;
    }

    public OperationStatusBackupVaultContexts operationStatusBackupVaultContexts() {
        if (this.operationStatusBackupVaultContexts == null) {
            this.operationStatusBackupVaultContexts = new OperationStatusBackupVaultContextsImpl(this.clientObject.getOperationStatusBackupVaultContexts(), this);
        }
        return this.operationStatusBackupVaultContexts;
    }

    public ExportJobs exportJobs() {
        if (this.exportJobs == null) {
            this.exportJobs = new ExportJobsImpl(this.clientObject.getExportJobs(), this);
        }
        return this.exportJobs;
    }

    public ExportJobsOperationResults exportJobsOperationResults() {
        if (this.exportJobsOperationResults == null) {
            this.exportJobsOperationResults = new ExportJobsOperationResultsImpl(this.clientObject.getExportJobsOperationResults(), this);
        }
        return this.exportJobsOperationResults;
    }

    public BackupPolicies backupPolicies() {
        if (this.backupPolicies == null) {
            this.backupPolicies = new BackupPoliciesImpl(this.clientObject.getBackupPolicies(), this);
        }
        return this.backupPolicies;
    }

    public RestorableTimeRanges restorableTimeRanges() {
        if (this.restorableTimeRanges == null) {
            this.restorableTimeRanges = new RestorableTimeRangesImpl(this.clientObject.getRestorableTimeRanges(), this);
        }
        return this.restorableTimeRanges;
    }

    public RecoveryPoints recoveryPoints() {
        if (this.recoveryPoints == null) {
            this.recoveryPoints = new RecoveryPointsImpl(this.clientObject.getRecoveryPoints(), this);
        }
        return this.recoveryPoints;
    }

    public Jobs jobs() {
        if (this.jobs == null) {
            this.jobs = new JobsImpl(this.clientObject.getJobs(), this);
        }
        return this.jobs;
    }

    public DeletedBackupInstances deletedBackupInstances() {
        if (this.deletedBackupInstances == null) {
            this.deletedBackupInstances = new DeletedBackupInstancesImpl(this.clientObject.getDeletedBackupInstances(), this);
        }
        return this.deletedBackupInstances;
    }

    public DppResourceGuardProxies dppResourceGuardProxies() {
        if (this.dppResourceGuardProxies == null) {
            this.dppResourceGuardProxies = new DppResourceGuardProxiesImpl(this.clientObject.getDppResourceGuardProxies(), this);
        }
        return this.dppResourceGuardProxies;
    }

    public OperationResults operationResults() {
        if (this.operationResults == null) {
            this.operationResults = new OperationResultsImpl(this.clientObject.getOperationResults(), this);
        }
        return this.operationResults;
    }

    public OperationStatus operationStatus() {
        if (this.operationStatus == null) {
            this.operationStatus = new OperationStatusImpl(this.clientObject.getOperationStatus(), this);
        }
        return this.operationStatus;
    }

    public OperationStatusResourceGroupContexts operationStatusResourceGroupContexts() {
        if (this.operationStatusResourceGroupContexts == null) {
            this.operationStatusResourceGroupContexts = new OperationStatusResourceGroupContextsImpl(this.clientObject.getOperationStatusResourceGroupContexts(), this);
        }
        return this.operationStatusResourceGroupContexts;
    }

    public DataProtections dataProtections() {
        if (this.dataProtections == null) {
            this.dataProtections = new DataProtectionsImpl(this.clientObject.getDataProtections(), this);
        }
        return this.dataProtections;
    }

    public FetchSecondaryRecoveryPoints fetchSecondaryRecoveryPoints() {
        if (this.fetchSecondaryRecoveryPoints == null) {
            this.fetchSecondaryRecoveryPoints = new FetchSecondaryRecoveryPointsImpl(this.clientObject.getFetchSecondaryRecoveryPoints(), this);
        }
        return this.fetchSecondaryRecoveryPoints;
    }

    public FetchCrossRegionRestoreJobs fetchCrossRegionRestoreJobs() {
        if (this.fetchCrossRegionRestoreJobs == null) {
            this.fetchCrossRegionRestoreJobs = new FetchCrossRegionRestoreJobsImpl(this.clientObject.getFetchCrossRegionRestoreJobs(), this);
        }
        return this.fetchCrossRegionRestoreJobs;
    }

    public FetchCrossRegionRestoreJobsOperations fetchCrossRegionRestoreJobsOperations() {
        if (this.fetchCrossRegionRestoreJobsOperations == null) {
            this.fetchCrossRegionRestoreJobsOperations = new FetchCrossRegionRestoreJobsOperationsImpl(this.clientObject.getFetchCrossRegionRestoreJobsOperations(), this);
        }
        return this.fetchCrossRegionRestoreJobsOperations;
    }

    public BackupInstancesExtensionRoutings backupInstancesExtensionRoutings() {
        if (this.backupInstancesExtensionRoutings == null) {
            this.backupInstancesExtensionRoutings = new BackupInstancesExtensionRoutingsImpl(this.clientObject.getBackupInstancesExtensionRoutings(), this);
        }
        return this.backupInstancesExtensionRoutings;
    }

    public DataProtectionManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-dataprotection.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public DataProtectionManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.dataprotection").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new DataProtectionManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

