/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupInstance;
import java.io.IOException;

public final class ValidateForModifyBackupRequest
implements JsonSerializable<ValidateForModifyBackupRequest> {
    private BackupInstance backupInstance;
    private static final ClientLogger LOGGER = new ClientLogger(ValidateForModifyBackupRequest.class);

    public BackupInstance backupInstance() {
        return this.backupInstance;
    }

    public ValidateForModifyBackupRequest withBackupInstance(BackupInstance backupInstance) {
        this.backupInstance = backupInstance;
        return this;
    }

    public void validate() {
        if (this.backupInstance() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupInstance in model ValidateForModifyBackupRequest"));
        }
        this.backupInstance().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backupInstance", (JsonSerializable)this.backupInstance);
        return jsonWriter.writeEndObject();
    }

    public static ValidateForModifyBackupRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ValidateForModifyBackupRequest)jsonReader.readObject(reader -> {
            ValidateForModifyBackupRequest deserializedValidateForModifyBackupRequest = new ValidateForModifyBackupRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupInstance".equals(fieldName)) {
                    deserializedValidateForModifyBackupRequest.backupInstance = BackupInstance.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateForModifyBackupRequest;
        });
    }
}

