/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.CopyOption;
import com.azure.resourcemanager.dataprotection.models.DataStoreInfoBase;
import java.io.IOException;

public final class TargetCopySetting
implements JsonSerializable<TargetCopySetting> {
    private CopyOption copyAfter;
    private DataStoreInfoBase dataStore;
    private static final ClientLogger LOGGER = new ClientLogger(TargetCopySetting.class);

    public CopyOption copyAfter() {
        return this.copyAfter;
    }

    public TargetCopySetting withCopyAfter(CopyOption copyAfter) {
        this.copyAfter = copyAfter;
        return this;
    }

    public DataStoreInfoBase dataStore() {
        return this.dataStore;
    }

    public TargetCopySetting withDataStore(DataStoreInfoBase dataStore) {
        this.dataStore = dataStore;
        return this;
    }

    public void validate() {
        if (this.copyAfter() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property copyAfter in model TargetCopySetting"));
        }
        this.copyAfter().validate();
        if (this.dataStore() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataStore in model TargetCopySetting"));
        }
        this.dataStore().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("copyAfter", (JsonSerializable)this.copyAfter);
        jsonWriter.writeJsonField("dataStore", (JsonSerializable)this.dataStore);
        return jsonWriter.writeEndObject();
    }

    public static TargetCopySetting fromJson(JsonReader jsonReader) throws IOException {
        return (TargetCopySetting)jsonReader.readObject(reader -> {
            TargetCopySetting deserializedTargetCopySetting = new TargetCopySetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("copyAfter".equals(fieldName)) {
                    deserializedTargetCopySetting.copyAfter = CopyOption.fromJson(reader);
                    continue;
                }
                if ("dataStore".equals(fieldName)) {
                    deserializedTargetCopySetting.dataStore = DataStoreInfoBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetCopySetting;
        });
    }
}

