/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupCriteria;
import com.azure.resourcemanager.dataprotection.models.RetentionTag;
import java.io.IOException;
import java.util.List;

public final class TaggingCriteria
implements JsonSerializable<TaggingCriteria> {
    private List<BackupCriteria> criteria;
    private boolean isDefault;
    private long taggingPriority;
    private RetentionTag tagInfo;
    private static final ClientLogger LOGGER = new ClientLogger(TaggingCriteria.class);

    public List<BackupCriteria> criteria() {
        return this.criteria;
    }

    public TaggingCriteria withCriteria(List<BackupCriteria> criteria) {
        this.criteria = criteria;
        return this;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public TaggingCriteria withIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public long taggingPriority() {
        return this.taggingPriority;
    }

    public TaggingCriteria withTaggingPriority(long taggingPriority) {
        this.taggingPriority = taggingPriority;
        return this;
    }

    public RetentionTag tagInfo() {
        return this.tagInfo;
    }

    public TaggingCriteria withTagInfo(RetentionTag tagInfo) {
        this.tagInfo = tagInfo;
        return this;
    }

    public void validate() {
        if (this.criteria() != null) {
            this.criteria().forEach(e -> e.validate());
        }
        if (this.tagInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tagInfo in model TaggingCriteria"));
        }
        this.tagInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeLongField("taggingPriority", this.taggingPriority);
        jsonWriter.writeJsonField("tagInfo", (JsonSerializable)this.tagInfo);
        jsonWriter.writeArrayField("criteria", this.criteria, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TaggingCriteria fromJson(JsonReader jsonReader) throws IOException {
        return (TaggingCriteria)jsonReader.readObject(reader -> {
            TaggingCriteria deserializedTaggingCriteria = new TaggingCriteria();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isDefault".equals(fieldName)) {
                    deserializedTaggingCriteria.isDefault = reader.getBoolean();
                    continue;
                }
                if ("taggingPriority".equals(fieldName)) {
                    deserializedTaggingCriteria.taggingPriority = reader.getLong();
                    continue;
                }
                if ("tagInfo".equals(fieldName)) {
                    deserializedTaggingCriteria.tagInfo = RetentionTag.fromJson(reader);
                    continue;
                }
                if ("criteria".equals(fieldName)) {
                    List criteria;
                    deserializedTaggingCriteria.criteria = criteria = reader.readArray(reader1 -> BackupCriteria.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaggingCriteria;
        });
    }
}

