/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.DataStoreInfoBase;
import com.azure.resourcemanager.dataprotection.models.DeleteOption;
import com.azure.resourcemanager.dataprotection.models.TargetCopySetting;
import java.io.IOException;
import java.util.List;

public final class SourceLifeCycle
implements JsonSerializable<SourceLifeCycle> {
    private DeleteOption deleteAfter;
    private DataStoreInfoBase sourceDataStore;
    private List<TargetCopySetting> targetDataStoreCopySettings;
    private static final ClientLogger LOGGER = new ClientLogger(SourceLifeCycle.class);

    public DeleteOption deleteAfter() {
        return this.deleteAfter;
    }

    public SourceLifeCycle withDeleteAfter(DeleteOption deleteAfter) {
        this.deleteAfter = deleteAfter;
        return this;
    }

    public DataStoreInfoBase sourceDataStore() {
        return this.sourceDataStore;
    }

    public SourceLifeCycle withSourceDataStore(DataStoreInfoBase sourceDataStore) {
        this.sourceDataStore = sourceDataStore;
        return this;
    }

    public List<TargetCopySetting> targetDataStoreCopySettings() {
        return this.targetDataStoreCopySettings;
    }

    public SourceLifeCycle withTargetDataStoreCopySettings(List<TargetCopySetting> targetDataStoreCopySettings) {
        this.targetDataStoreCopySettings = targetDataStoreCopySettings;
        return this;
    }

    public void validate() {
        if (this.deleteAfter() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deleteAfter in model SourceLifeCycle"));
        }
        this.deleteAfter().validate();
        if (this.sourceDataStore() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceDataStore in model SourceLifeCycle"));
        }
        this.sourceDataStore().validate();
        if (this.targetDataStoreCopySettings() != null) {
            this.targetDataStoreCopySettings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("deleteAfter", (JsonSerializable)this.deleteAfter);
        jsonWriter.writeJsonField("sourceDataStore", (JsonSerializable)this.sourceDataStore);
        jsonWriter.writeArrayField("targetDataStoreCopySettings", this.targetDataStoreCopySettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SourceLifeCycle fromJson(JsonReader jsonReader) throws IOException {
        return (SourceLifeCycle)jsonReader.readObject(reader -> {
            SourceLifeCycle deserializedSourceLifeCycle = new SourceLifeCycle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deleteAfter".equals(fieldName)) {
                    deserializedSourceLifeCycle.deleteAfter = DeleteOption.fromJson(reader);
                    continue;
                }
                if ("sourceDataStore".equals(fieldName)) {
                    deserializedSourceLifeCycle.sourceDataStore = DataStoreInfoBase.fromJson(reader);
                    continue;
                }
                if ("targetDataStoreCopySettings".equals(fieldName)) {
                    List targetDataStoreCopySettings;
                    deserializedSourceLifeCycle.targetDataStoreCopySettings = targetDataStoreCopySettings = reader.readArray(reader1 -> TargetCopySetting.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceLifeCycle;
        });
    }
}

