/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.SoftDeleteState;
import java.io.IOException;

public final class SoftDeleteSettings
implements JsonSerializable<SoftDeleteSettings> {
    private SoftDeleteState state;
    private Double retentionDurationInDays;

    public SoftDeleteState state() {
        return this.state;
    }

    public SoftDeleteSettings withState(SoftDeleteState state) {
        this.state = state;
        return this;
    }

    public Double retentionDurationInDays() {
        return this.retentionDurationInDays;
    }

    public SoftDeleteSettings withRetentionDurationInDays(Double retentionDurationInDays) {
        this.retentionDurationInDays = retentionDurationInDays;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeNumberField("retentionDurationInDays", (Number)this.retentionDurationInDays);
        return jsonWriter.writeEndObject();
    }

    public static SoftDeleteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (SoftDeleteSettings)jsonReader.readObject(reader -> {
            SoftDeleteSettings deserializedSoftDeleteSettings = new SoftDeleteSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedSoftDeleteSettings.state = SoftDeleteState.fromString(reader.getString());
                    continue;
                }
                if ("retentionDurationInDays".equals(fieldName)) {
                    deserializedSoftDeleteSettings.retentionDurationInDays = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSoftDeleteSettings;
        });
    }
}

