/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.SecretStoreType;
import java.io.IOException;

public final class SecretStoreResource
implements JsonSerializable<SecretStoreResource> {
    private String uri;
    private SecretStoreType secretStoreType;
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(SecretStoreResource.class);

    public String uri() {
        return this.uri;
    }

    public SecretStoreResource withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public SecretStoreType secretStoreType() {
        return this.secretStoreType;
    }

    public SecretStoreResource withSecretStoreType(SecretStoreType secretStoreType) {
        this.secretStoreType = secretStoreType;
        return this;
    }

    public String value() {
        return this.value;
    }

    public SecretStoreResource withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.secretStoreType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretStoreType in model SecretStoreResource"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretStoreType", this.secretStoreType == null ? null : this.secretStoreType.toString());
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static SecretStoreResource fromJson(JsonReader jsonReader) throws IOException {
        return (SecretStoreResource)jsonReader.readObject(reader -> {
            SecretStoreResource deserializedSecretStoreResource = new SecretStoreResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("secretStoreType".equals(fieldName)) {
                    deserializedSecretStoreResource.secretStoreType = SecretStoreType.fromString(reader.getString());
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedSecretStoreResource.uri = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedSecretStoreResource.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretStoreResource;
        });
    }
}

