/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AuthCredentials;
import com.azure.resourcemanager.dataprotection.models.SecretStoreResource;
import java.io.IOException;

public final class SecretStoreBasedAuthCredentials
extends AuthCredentials {
    private String objectType = "SecretStoreBasedAuthCredentials";
    private SecretStoreResource secretStoreResource;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public SecretStoreResource secretStoreResource() {
        return this.secretStoreResource;
    }

    public SecretStoreBasedAuthCredentials withSecretStoreResource(SecretStoreResource secretStoreResource) {
        this.secretStoreResource = secretStoreResource;
        return this;
    }

    @Override
    public void validate() {
        if (this.secretStoreResource() != null) {
            this.secretStoreResource().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeJsonField("secretStoreResource", (JsonSerializable)this.secretStoreResource);
        return jsonWriter.writeEndObject();
    }

    public static SecretStoreBasedAuthCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (SecretStoreBasedAuthCredentials)jsonReader.readObject(reader -> {
            SecretStoreBasedAuthCredentials deserializedSecretStoreBasedAuthCredentials = new SecretStoreBasedAuthCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("objectType".equals(fieldName)) {
                    deserializedSecretStoreBasedAuthCredentials.objectType = reader.getString();
                    continue;
                }
                if ("secretStoreResource".equals(fieldName)) {
                    deserializedSecretStoreBasedAuthCredentials.secretStoreResource = SecretStoreResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretStoreBasedAuthCredentials;
        });
    }
}

