/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.fluent.models.ResourceGuardResourceInner;
import com.azure.resourcemanager.dataprotection.models.DppTrackedResourceList;
import java.io.IOException;
import java.util.List;

public final class ResourceGuardResourceList
extends DppTrackedResourceList {
    private List<ResourceGuardResourceInner> value;

    public List<ResourceGuardResourceInner> value() {
        return this.value;
    }

    public ResourceGuardResourceList withValue(List<ResourceGuardResourceInner> value) {
        this.value = value;
        return this;
    }

    @Override
    public ResourceGuardResourceList withNextLink(String nextLink) {
        super.withNextLink(nextLink);
        return this;
    }

    @Override
    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink());
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceGuardResourceList fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGuardResourceList)jsonReader.readObject(reader -> {
            ResourceGuardResourceList deserializedResourceGuardResourceList = new ResourceGuardResourceList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceGuardResourceList.withNextLink(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceGuardResourceList.value = value = reader.readArray(reader1 -> ResourceGuardResourceInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGuardResourceList;
        });
    }
}

