/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupDatasourceParameters;
import com.azure.resourcemanager.dataprotection.models.DataStoreParameters;
import java.io.IOException;
import java.util.List;

public final class PolicyParameters
implements JsonSerializable<PolicyParameters> {
    private List<DataStoreParameters> dataStoreParametersList;
    private List<BackupDatasourceParameters> backupDatasourceParametersList;

    public List<DataStoreParameters> dataStoreParametersList() {
        return this.dataStoreParametersList;
    }

    public PolicyParameters withDataStoreParametersList(List<DataStoreParameters> dataStoreParametersList) {
        this.dataStoreParametersList = dataStoreParametersList;
        return this;
    }

    public List<BackupDatasourceParameters> backupDatasourceParametersList() {
        return this.backupDatasourceParametersList;
    }

    public PolicyParameters withBackupDatasourceParametersList(List<BackupDatasourceParameters> backupDatasourceParametersList) {
        this.backupDatasourceParametersList = backupDatasourceParametersList;
        return this;
    }

    public void validate() {
        if (this.dataStoreParametersList() != null) {
            this.dataStoreParametersList().forEach(e -> e.validate());
        }
        if (this.backupDatasourceParametersList() != null) {
            this.backupDatasourceParametersList().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dataStoreParametersList", this.dataStoreParametersList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("backupDatasourceParametersList", this.backupDatasourceParametersList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyParameters)jsonReader.readObject(reader -> {
            PolicyParameters deserializedPolicyParameters = new PolicyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataStoreParametersList".equals(fieldName)) {
                    List dataStoreParametersList;
                    deserializedPolicyParameters.dataStoreParametersList = dataStoreParametersList = reader.readArray(reader1 -> DataStoreParameters.fromJson(reader1));
                    continue;
                }
                if ("backupDatasourceParametersList".equals(fieldName)) {
                    List backupDatasourceParametersList;
                    deserializedPolicyParameters.backupDatasourceParametersList = backupDatasourceParametersList = reader.readArray(reader1 -> BackupDatasourceParameters.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyParameters;
        });
    }
}

