/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.DppIdentityDetails;
import com.azure.resourcemanager.dataprotection.models.PatchBackupVaultInput;
import java.io.IOException;
import java.util.Map;

public final class PatchResourceRequestInput
implements JsonSerializable<PatchResourceRequestInput> {
    private DppIdentityDetails identity;
    private PatchBackupVaultInput properties;
    private Map<String, String> tags;

    public DppIdentityDetails identity() {
        return this.identity;
    }

    public PatchResourceRequestInput withIdentity(DppIdentityDetails identity) {
        this.identity = identity;
        return this;
    }

    public PatchBackupVaultInput properties() {
        return this.properties;
    }

    public PatchResourceRequestInput withProperties(PatchBackupVaultInput properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public PatchResourceRequestInput withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PatchResourceRequestInput fromJson(JsonReader jsonReader) throws IOException {
        return (PatchResourceRequestInput)jsonReader.readObject(reader -> {
            PatchResourceRequestInput deserializedPatchResourceRequestInput = new PatchResourceRequestInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedPatchResourceRequestInput.identity = DppIdentityDetails.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPatchResourceRequestInput.properties = PatchBackupVaultInput.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedPatchResourceRequestInput.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPatchResourceRequestInput;
        });
    }
}

