/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.fluent.models.FeatureValidationResponseBaseInner;
import com.azure.resourcemanager.dataprotection.models.FeatureType;
import com.azure.resourcemanager.dataprotection.models.SupportedFeature;
import java.io.IOException;
import java.util.List;

public final class FeatureValidationResponse
extends FeatureValidationResponseBaseInner {
    private String objectType = "FeatureValidationResponse";
    private FeatureType featureType;
    private List<SupportedFeature> features;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public FeatureType featureType() {
        return this.featureType;
    }

    public FeatureValidationResponse withFeatureType(FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }

    public List<SupportedFeature> features() {
        return this.features;
    }

    public FeatureValidationResponse withFeatures(List<SupportedFeature> features) {
        this.features = features;
        return this;
    }

    @Override
    public void validate() {
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("featureType", this.featureType == null ? null : this.featureType.toString());
        jsonWriter.writeArrayField("features", this.features, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FeatureValidationResponse fromJson(JsonReader jsonReader) throws IOException {
        return (FeatureValidationResponse)jsonReader.readObject(reader -> {
            FeatureValidationResponse deserializedFeatureValidationResponse = new FeatureValidationResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("objectType".equals(fieldName)) {
                    deserializedFeatureValidationResponse.objectType = reader.getString();
                    continue;
                }
                if ("featureType".equals(fieldName)) {
                    deserializedFeatureValidationResponse.featureType = FeatureType.fromString(reader.getString());
                    continue;
                }
                if ("features".equals(fieldName)) {
                    List features;
                    deserializedFeatureValidationResponse.features = features = reader.readArray(reader1 -> SupportedFeature.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFeatureValidationResponse;
        });
    }
}

