/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.FeatureType;
import com.azure.resourcemanager.dataprotection.models.FeatureValidationRequestBase;
import java.io.IOException;

public final class FeatureValidationRequest
extends FeatureValidationRequestBase {
    private String objectType = "FeatureValidationRequest";
    private FeatureType featureType;
    private String featureName;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public FeatureType featureType() {
        return this.featureType;
    }

    public FeatureValidationRequest withFeatureType(FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }

    public String featureName() {
        return this.featureName;
    }

    public FeatureValidationRequest withFeatureName(String featureName) {
        this.featureName = featureName;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("featureType", this.featureType == null ? null : this.featureType.toString());
        jsonWriter.writeStringField("featureName", this.featureName);
        return jsonWriter.writeEndObject();
    }

    public static FeatureValidationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (FeatureValidationRequest)jsonReader.readObject(reader -> {
            FeatureValidationRequest deserializedFeatureValidationRequest = new FeatureValidationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("objectType".equals(fieldName)) {
                    deserializedFeatureValidationRequest.objectType = reader.getString();
                    continue;
                }
                if ("featureType".equals(fieldName)) {
                    deserializedFeatureValidationRequest.featureType = FeatureType.fromString(reader.getString());
                    continue;
                }
                if ("featureName".equals(fieldName)) {
                    deserializedFeatureValidationRequest.featureName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFeatureValidationRequest;
        });
    }
}

