/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.CmkKekIdentity;
import com.azure.resourcemanager.dataprotection.models.CmkKeyVaultProperties;
import com.azure.resourcemanager.dataprotection.models.EncryptionState;
import com.azure.resourcemanager.dataprotection.models.InfrastructureEncryptionState;
import java.io.IOException;

public final class EncryptionSettings
implements JsonSerializable<EncryptionSettings> {
    private EncryptionState state;
    private CmkKeyVaultProperties keyVaultProperties;
    private CmkKekIdentity kekIdentity;
    private InfrastructureEncryptionState infrastructureEncryption;

    public EncryptionState state() {
        return this.state;
    }

    public EncryptionSettings withState(EncryptionState state) {
        this.state = state;
        return this;
    }

    public CmkKeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public EncryptionSettings withKeyVaultProperties(CmkKeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public CmkKekIdentity kekIdentity() {
        return this.kekIdentity;
    }

    public EncryptionSettings withKekIdentity(CmkKekIdentity kekIdentity) {
        this.kekIdentity = kekIdentity;
        return this;
    }

    public InfrastructureEncryptionState infrastructureEncryption() {
        return this.infrastructureEncryption;
    }

    public EncryptionSettings withInfrastructureEncryption(InfrastructureEncryptionState infrastructureEncryption) {
        this.infrastructureEncryption = infrastructureEncryption;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.kekIdentity() != null) {
            this.kekIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeJsonField("kekIdentity", (JsonSerializable)this.kekIdentity);
        jsonWriter.writeStringField("infrastructureEncryption", this.infrastructureEncryption == null ? null : this.infrastructureEncryption.toString());
        return jsonWriter.writeEndObject();
    }

    public static EncryptionSettings fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionSettings)jsonReader.readObject(reader -> {
            EncryptionSettings deserializedEncryptionSettings = new EncryptionSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedEncryptionSettings.state = EncryptionState.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedEncryptionSettings.keyVaultProperties = CmkKeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("kekIdentity".equals(fieldName)) {
                    deserializedEncryptionSettings.kekIdentity = CmkKekIdentity.fromJson(reader);
                    continue;
                }
                if ("infrastructureEncryption".equals(fieldName)) {
                    deserializedEncryptionSettings.infrastructureEncryption = InfrastructureEncryptionState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionSettings;
        });
    }
}

