/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DppWorkerRequest
implements JsonSerializable<DppWorkerRequest> {
    private String subscriptionId;
    private String uri;
    private Map<String, List<String>> headers;
    private List<String> supportedGroupVersions;
    private String cultureInfo;
    private Map<String, String> parameters;
    private String httpMethod;

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public DppWorkerRequest withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public DppWorkerRequest withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public DppWorkerRequest withHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public List<String> supportedGroupVersions() {
        return this.supportedGroupVersions;
    }

    public DppWorkerRequest withSupportedGroupVersions(List<String> supportedGroupVersions) {
        this.supportedGroupVersions = supportedGroupVersions;
        return this;
    }

    public String cultureInfo() {
        return this.cultureInfo;
    }

    public DppWorkerRequest withCultureInfo(String cultureInfo) {
        this.cultureInfo = cultureInfo;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public DppWorkerRequest withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public DppWorkerRequest withHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeString(element1)));
        jsonWriter.writeArrayField("supportedGroupVersions", this.supportedGroupVersions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("cultureInfo", this.cultureInfo);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("httpMethod", this.httpMethod);
        return jsonWriter.writeEndObject();
    }

    public static DppWorkerRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DppWorkerRequest)jsonReader.readObject(reader -> {
            DppWorkerRequest deserializedDppWorkerRequest = new DppWorkerRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subscriptionId".equals(fieldName)) {
                    deserializedDppWorkerRequest.subscriptionId = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedDppWorkerRequest.uri = reader.getString();
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    Map headers;
                    deserializedDppWorkerRequest.headers = headers = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                if ("supportedGroupVersions".equals(fieldName)) {
                    List supportedGroupVersions;
                    deserializedDppWorkerRequest.supportedGroupVersions = supportedGroupVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("cultureInfo".equals(fieldName)) {
                    deserializedDppWorkerRequest.cultureInfo = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDppWorkerRequest.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("httpMethod".equals(fieldName)) {
                    deserializedDppWorkerRequest.httpMethod = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDppWorkerRequest;
        });
    }
}

