/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class DppBaseTrackedResource
extends Resource {
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public String etag() {
        return this.etag;
    }

    public DppBaseTrackedResource withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    DppBaseTrackedResource withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DppBaseTrackedResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DppBaseTrackedResource withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("eTag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static DppBaseTrackedResource fromJson(JsonReader jsonReader) throws IOException {
        return (DppBaseTrackedResource)((Object)jsonReader.readObject(reader -> {
            DppBaseTrackedResource deserializedDppBaseTrackedResource = new DppBaseTrackedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDppBaseTrackedResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDppBaseTrackedResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDppBaseTrackedResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDppBaseTrackedResource.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDppBaseTrackedResource.withTags(tags);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedDppBaseTrackedResource.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDppBaseTrackedResource.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDppBaseTrackedResource;
        }));
    }
}

