/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AuthCredentials;
import com.azure.resourcemanager.dataprotection.models.BackupInstance;
import com.azure.resourcemanager.dataprotection.models.CurrentProtectionState;
import com.azure.resourcemanager.dataprotection.models.Datasource;
import com.azure.resourcemanager.dataprotection.models.DatasourceSet;
import com.azure.resourcemanager.dataprotection.models.DeletionInfo;
import com.azure.resourcemanager.dataprotection.models.IdentityDetails;
import com.azure.resourcemanager.dataprotection.models.PolicyInfo;
import com.azure.resourcemanager.dataprotection.models.ProtectionStatusDetails;
import com.azure.resourcemanager.dataprotection.models.UserFacingError;
import com.azure.resourcemanager.dataprotection.models.ValidationType;
import java.io.IOException;
import java.util.List;

public final class DeletedBackupInstance
extends BackupInstance {
    private DeletionInfo deletionInfo;
    private String provisioningState;
    private UserFacingError protectionErrorDetails;
    private CurrentProtectionState currentProtectionState;
    private ProtectionStatusDetails protectionStatus;
    private static final ClientLogger LOGGER = new ClientLogger(DeletedBackupInstance.class);

    public DeletionInfo deletionInfo() {
        return this.deletionInfo;
    }

    @Override
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public UserFacingError protectionErrorDetails() {
        return this.protectionErrorDetails;
    }

    @Override
    public CurrentProtectionState currentProtectionState() {
        return this.currentProtectionState;
    }

    @Override
    public ProtectionStatusDetails protectionStatus() {
        return this.protectionStatus;
    }

    @Override
    public DeletedBackupInstance withFriendlyName(String friendlyName) {
        super.withFriendlyName(friendlyName);
        return this;
    }

    @Override
    public DeletedBackupInstance withDataSourceInfo(Datasource dataSourceInfo) {
        super.withDataSourceInfo(dataSourceInfo);
        return this;
    }

    @Override
    public DeletedBackupInstance withDataSourceSetInfo(DatasourceSet dataSourceSetInfo) {
        super.withDataSourceSetInfo(dataSourceSetInfo);
        return this;
    }

    @Override
    public DeletedBackupInstance withPolicyInfo(PolicyInfo policyInfo) {
        super.withPolicyInfo(policyInfo);
        return this;
    }

    @Override
    public DeletedBackupInstance withResourceGuardOperationRequests(List<String> resourceGuardOperationRequests) {
        super.withResourceGuardOperationRequests(resourceGuardOperationRequests);
        return this;
    }

    @Override
    public DeletedBackupInstance withDatasourceAuthCredentials(AuthCredentials datasourceAuthCredentials) {
        super.withDatasourceAuthCredentials(datasourceAuthCredentials);
        return this;
    }

    @Override
    public DeletedBackupInstance withValidationType(ValidationType validationType) {
        super.withValidationType(validationType);
        return this;
    }

    @Override
    public DeletedBackupInstance withIdentityDetails(IdentityDetails identityDetails) {
        super.withIdentityDetails(identityDetails);
        return this;
    }

    @Override
    public DeletedBackupInstance withObjectType(String objectType) {
        super.withObjectType(objectType);
        return this;
    }

    @Override
    public void validate() {
        if (this.deletionInfo() != null) {
            this.deletionInfo().validate();
        }
        if (this.dataSourceInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataSourceInfo in model DeletedBackupInstance"));
        }
        this.dataSourceInfo().validate();
        if (this.dataSourceSetInfo() != null) {
            this.dataSourceSetInfo().validate();
        }
        if (this.policyInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policyInfo in model DeletedBackupInstance"));
        }
        this.policyInfo().validate();
        if (this.protectionStatus() != null) {
            this.protectionStatus().validate();
        }
        if (this.protectionErrorDetails() != null) {
            this.protectionErrorDetails().validate();
        }
        if (this.datasourceAuthCredentials() != null) {
            this.datasourceAuthCredentials().validate();
        }
        if (this.identityDetails() != null) {
            this.identityDetails().validate();
        }
        if (this.objectType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property objectType in model DeletedBackupInstance"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataSourceInfo", (JsonSerializable)this.dataSourceInfo());
        jsonWriter.writeJsonField("policyInfo", (JsonSerializable)this.policyInfo());
        jsonWriter.writeStringField("objectType", this.objectType());
        jsonWriter.writeStringField("friendlyName", this.friendlyName());
        jsonWriter.writeJsonField("dataSourceSetInfo", (JsonSerializable)this.dataSourceSetInfo());
        jsonWriter.writeArrayField("resourceGuardOperationRequests", this.resourceGuardOperationRequests(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("datasourceAuthCredentials", (JsonSerializable)this.datasourceAuthCredentials());
        jsonWriter.writeStringField("validationType", this.validationType() == null ? null : this.validationType().toString());
        jsonWriter.writeJsonField("identityDetails", (JsonSerializable)this.identityDetails());
        return jsonWriter.writeEndObject();
    }

    public static DeletedBackupInstance fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedBackupInstance)jsonReader.readObject(reader -> {
            DeletedBackupInstance deserializedDeletedBackupInstance = new DeletedBackupInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataSourceInfo".equals(fieldName)) {
                    deserializedDeletedBackupInstance.withDataSourceInfo(Datasource.fromJson(reader));
                    continue;
                }
                if ("policyInfo".equals(fieldName)) {
                    deserializedDeletedBackupInstance.withPolicyInfo(PolicyInfo.fromJson(reader));
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedDeletedBackupInstance.withObjectType(reader.getString());
                    continue;
                }
                if ("friendlyName".equals(fieldName)) {
                    deserializedDeletedBackupInstance.withFriendlyName(reader.getString());
                    continue;
                }
                if ("dataSourceSetInfo".equals(fieldName)) {
                    deserializedDeletedBackupInstance.withDataSourceSetInfo(DatasourceSet.fromJson(reader));
                    continue;
                }
                if ("resourceGuardOperationRequests".equals(fieldName)) {
                    List resourceGuardOperationRequests = reader.readArray(reader1 -> reader1.getString());
                    deserializedDeletedBackupInstance.withResourceGuardOperationRequests(resourceGuardOperationRequests);
                    continue;
                }
                if ("protectionStatus".equals(fieldName)) {
                    deserializedDeletedBackupInstance.protectionStatus = ProtectionStatusDetails.fromJson(reader);
                    continue;
                }
                if ("currentProtectionState".equals(fieldName)) {
                    deserializedDeletedBackupInstance.currentProtectionState = CurrentProtectionState.fromString(reader.getString());
                    continue;
                }
                if ("protectionErrorDetails".equals(fieldName)) {
                    deserializedDeletedBackupInstance.protectionErrorDetails = UserFacingError.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDeletedBackupInstance.provisioningState = reader.getString();
                    continue;
                }
                if ("datasourceAuthCredentials".equals(fieldName)) {
                    deserializedDeletedBackupInstance.withDatasourceAuthCredentials(AuthCredentials.fromJson(reader));
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedDeletedBackupInstance.withValidationType(ValidationType.fromString(reader.getString()));
                    continue;
                }
                if ("identityDetails".equals(fieldName)) {
                    deserializedDeletedBackupInstance.withIdentityDetails(IdentityDetails.fromJson(reader));
                    continue;
                }
                if ("deletionInfo".equals(fieldName)) {
                    deserializedDeletedBackupInstance.deletionInfo = DeletionInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedBackupInstance;
        });
    }
}

