/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BaseResourceProperties;
import java.io.IOException;

public final class Datasource
implements JsonSerializable<Datasource> {
    private String datasourceType;
    private String objectType;
    private String resourceId;
    private String resourceLocation;
    private String resourceName;
    private String resourceType;
    private String resourceUri;
    private BaseResourceProperties resourceProperties;
    private static final ClientLogger LOGGER = new ClientLogger(Datasource.class);

    public String datasourceType() {
        return this.datasourceType;
    }

    public Datasource withDatasourceType(String datasourceType) {
        this.datasourceType = datasourceType;
        return this;
    }

    public String objectType() {
        return this.objectType;
    }

    public Datasource withObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Datasource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String resourceLocation() {
        return this.resourceLocation;
    }

    public Datasource withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public Datasource withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Datasource withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public String resourceUri() {
        return this.resourceUri;
    }

    public Datasource withResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

    public BaseResourceProperties resourceProperties() {
        return this.resourceProperties;
    }

    public Datasource withResourceProperties(BaseResourceProperties resourceProperties) {
        this.resourceProperties = resourceProperties;
        return this;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model Datasource"));
        }
        if (this.resourceProperties() != null) {
            this.resourceProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceID", this.resourceId);
        jsonWriter.writeStringField("datasourceType", this.datasourceType);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeStringField("resourceUri", this.resourceUri);
        jsonWriter.writeJsonField("resourceProperties", (JsonSerializable)this.resourceProperties);
        return jsonWriter.writeEndObject();
    }

    public static Datasource fromJson(JsonReader jsonReader) throws IOException {
        return (Datasource)jsonReader.readObject(reader -> {
            Datasource deserializedDatasource = new Datasource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceID".equals(fieldName)) {
                    deserializedDatasource.resourceId = reader.getString();
                    continue;
                }
                if ("datasourceType".equals(fieldName)) {
                    deserializedDatasource.datasourceType = reader.getString();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedDatasource.objectType = reader.getString();
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    deserializedDatasource.resourceLocation = reader.getString();
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedDatasource.resourceName = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedDatasource.resourceType = reader.getString();
                    continue;
                }
                if ("resourceUri".equals(fieldName)) {
                    deserializedDatasource.resourceUri = reader.getString();
                    continue;
                }
                if ("resourceProperties".equals(fieldName)) {
                    deserializedDatasource.resourceProperties = BaseResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatasource;
        });
    }
}

