/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.DataStoreTypes;
import java.io.IOException;

public final class DataStoreInfoBase
implements JsonSerializable<DataStoreInfoBase> {
    private DataStoreTypes dataStoreType;
    private String objectType;
    private static final ClientLogger LOGGER = new ClientLogger(DataStoreInfoBase.class);

    public DataStoreTypes dataStoreType() {
        return this.dataStoreType;
    }

    public DataStoreInfoBase withDataStoreType(DataStoreTypes dataStoreType) {
        this.dataStoreType = dataStoreType;
        return this;
    }

    public String objectType() {
        return this.objectType;
    }

    public DataStoreInfoBase withObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public void validate() {
        if (this.dataStoreType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataStoreType in model DataStoreInfoBase"));
        }
        if (this.objectType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property objectType in model DataStoreInfoBase"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataStoreType", this.dataStoreType == null ? null : this.dataStoreType.toString());
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static DataStoreInfoBase fromJson(JsonReader jsonReader) throws IOException {
        return (DataStoreInfoBase)jsonReader.readObject(reader -> {
            DataStoreInfoBase deserializedDataStoreInfoBase = new DataStoreInfoBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataStoreType".equals(fieldName)) {
                    deserializedDataStoreInfoBase.dataStoreType = DataStoreTypes.fromString(reader.getString());
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedDataStoreInfoBase.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataStoreInfoBase;
        });
    }
}

