/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CrossRegionRestoreJobsRequest
implements JsonSerializable<CrossRegionRestoreJobsRequest> {
    private String sourceRegion;
    private String sourceBackupVaultId;
    private static final ClientLogger LOGGER = new ClientLogger(CrossRegionRestoreJobsRequest.class);

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public CrossRegionRestoreJobsRequest withSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
        return this;
    }

    public String sourceBackupVaultId() {
        return this.sourceBackupVaultId;
    }

    public CrossRegionRestoreJobsRequest withSourceBackupVaultId(String sourceBackupVaultId) {
        this.sourceBackupVaultId = sourceBackupVaultId;
        return this;
    }

    public void validate() {
        if (this.sourceRegion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceRegion in model CrossRegionRestoreJobsRequest"));
        }
        if (this.sourceBackupVaultId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceBackupVaultId in model CrossRegionRestoreJobsRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceRegion", this.sourceRegion);
        jsonWriter.writeStringField("sourceBackupVaultId", this.sourceBackupVaultId);
        return jsonWriter.writeEndObject();
    }

    public static CrossRegionRestoreJobsRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CrossRegionRestoreJobsRequest)jsonReader.readObject(reader -> {
            CrossRegionRestoreJobsRequest deserializedCrossRegionRestoreJobsRequest = new CrossRegionRestoreJobsRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRegion".equals(fieldName)) {
                    deserializedCrossRegionRestoreJobsRequest.sourceRegion = reader.getString();
                    continue;
                }
                if ("sourceBackupVaultId".equals(fieldName)) {
                    deserializedCrossRegionRestoreJobsRequest.sourceBackupVaultId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCrossRegionRestoreJobsRequest;
        });
    }
}

