/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupVaultResourceInner;
import com.azure.resourcemanager.dataprotection.models.BackupVault;
import com.azure.resourcemanager.dataprotection.models.DppIdentityDetails;
import com.azure.resourcemanager.dataprotection.models.PatchBackupVaultInput;
import java.util.Map;

public interface BackupVaultResource {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public SystemData systemData();

    public DppIdentityDetails identity();

    public BackupVault properties();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public BackupVaultResourceInner innerModel();

    public Update update();

    public BackupVaultResource refresh();

    public BackupVaultResource refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(PatchBackupVaultInput var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(DppIdentityDetails var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithProperties {
        public BackupVaultResource apply();

        public BackupVaultResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIdentity {
            public WithCreate withIdentity(DppIdentityDetails var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEtag,
        WithIdentity {
            public BackupVaultResource create();

            public BackupVaultResource create(Context var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(BackupVault var1);
        }

        public static interface WithResourceGroup {
            public WithProperties withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithProperties,
    DefinitionStages.WithCreate {
    }
}

