/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AuthCredentials;
import com.azure.resourcemanager.dataprotection.models.CurrentProtectionState;
import com.azure.resourcemanager.dataprotection.models.Datasource;
import com.azure.resourcemanager.dataprotection.models.DatasourceSet;
import com.azure.resourcemanager.dataprotection.models.IdentityDetails;
import com.azure.resourcemanager.dataprotection.models.PolicyInfo;
import com.azure.resourcemanager.dataprotection.models.ProtectionStatusDetails;
import com.azure.resourcemanager.dataprotection.models.UserFacingError;
import com.azure.resourcemanager.dataprotection.models.ValidationType;
import java.io.IOException;
import java.util.List;

public class BackupInstance
implements JsonSerializable<BackupInstance> {
    private String friendlyName;
    private Datasource dataSourceInfo;
    private DatasourceSet dataSourceSetInfo;
    private PolicyInfo policyInfo;
    private List<String> resourceGuardOperationRequests;
    private ProtectionStatusDetails protectionStatus;
    private CurrentProtectionState currentProtectionState;
    private UserFacingError protectionErrorDetails;
    private String provisioningState;
    private AuthCredentials datasourceAuthCredentials;
    private ValidationType validationType;
    private IdentityDetails identityDetails;
    private String objectType;
    private static final ClientLogger LOGGER = new ClientLogger(BackupInstance.class);

    public String friendlyName() {
        return this.friendlyName;
    }

    public BackupInstance withFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public Datasource dataSourceInfo() {
        return this.dataSourceInfo;
    }

    public BackupInstance withDataSourceInfo(Datasource dataSourceInfo) {
        this.dataSourceInfo = dataSourceInfo;
        return this;
    }

    public DatasourceSet dataSourceSetInfo() {
        return this.dataSourceSetInfo;
    }

    public BackupInstance withDataSourceSetInfo(DatasourceSet dataSourceSetInfo) {
        this.dataSourceSetInfo = dataSourceSetInfo;
        return this;
    }

    public PolicyInfo policyInfo() {
        return this.policyInfo;
    }

    public BackupInstance withPolicyInfo(PolicyInfo policyInfo) {
        this.policyInfo = policyInfo;
        return this;
    }

    public List<String> resourceGuardOperationRequests() {
        return this.resourceGuardOperationRequests;
    }

    public BackupInstance withResourceGuardOperationRequests(List<String> resourceGuardOperationRequests) {
        this.resourceGuardOperationRequests = resourceGuardOperationRequests;
        return this;
    }

    public ProtectionStatusDetails protectionStatus() {
        return this.protectionStatus;
    }

    BackupInstance withProtectionStatus(ProtectionStatusDetails protectionStatus) {
        this.protectionStatus = protectionStatus;
        return this;
    }

    public CurrentProtectionState currentProtectionState() {
        return this.currentProtectionState;
    }

    BackupInstance withCurrentProtectionState(CurrentProtectionState currentProtectionState) {
        this.currentProtectionState = currentProtectionState;
        return this;
    }

    public UserFacingError protectionErrorDetails() {
        return this.protectionErrorDetails;
    }

    BackupInstance withProtectionErrorDetails(UserFacingError protectionErrorDetails) {
        this.protectionErrorDetails = protectionErrorDetails;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    BackupInstance withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public AuthCredentials datasourceAuthCredentials() {
        return this.datasourceAuthCredentials;
    }

    public BackupInstance withDatasourceAuthCredentials(AuthCredentials datasourceAuthCredentials) {
        this.datasourceAuthCredentials = datasourceAuthCredentials;
        return this;
    }

    public ValidationType validationType() {
        return this.validationType;
    }

    public BackupInstance withValidationType(ValidationType validationType) {
        this.validationType = validationType;
        return this;
    }

    public IdentityDetails identityDetails() {
        return this.identityDetails;
    }

    public BackupInstance withIdentityDetails(IdentityDetails identityDetails) {
        this.identityDetails = identityDetails;
        return this;
    }

    public String objectType() {
        return this.objectType;
    }

    public BackupInstance withObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public void validate() {
        if (this.dataSourceInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataSourceInfo in model BackupInstance"));
        }
        this.dataSourceInfo().validate();
        if (this.dataSourceSetInfo() != null) {
            this.dataSourceSetInfo().validate();
        }
        if (this.policyInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policyInfo in model BackupInstance"));
        }
        this.policyInfo().validate();
        if (this.protectionStatus() != null) {
            this.protectionStatus().validate();
        }
        if (this.protectionErrorDetails() != null) {
            this.protectionErrorDetails().validate();
        }
        if (this.datasourceAuthCredentials() != null) {
            this.datasourceAuthCredentials().validate();
        }
        if (this.identityDetails() != null) {
            this.identityDetails().validate();
        }
        if (this.objectType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property objectType in model BackupInstance"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataSourceInfo", (JsonSerializable)this.dataSourceInfo);
        jsonWriter.writeJsonField("policyInfo", (JsonSerializable)this.policyInfo);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("friendlyName", this.friendlyName);
        jsonWriter.writeJsonField("dataSourceSetInfo", (JsonSerializable)this.dataSourceSetInfo);
        jsonWriter.writeArrayField("resourceGuardOperationRequests", this.resourceGuardOperationRequests, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("datasourceAuthCredentials", (JsonSerializable)this.datasourceAuthCredentials);
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        jsonWriter.writeJsonField("identityDetails", (JsonSerializable)this.identityDetails);
        return jsonWriter.writeEndObject();
    }

    public static BackupInstance fromJson(JsonReader jsonReader) throws IOException {
        return (BackupInstance)jsonReader.readObject(reader -> {
            BackupInstance deserializedBackupInstance = new BackupInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataSourceInfo".equals(fieldName)) {
                    deserializedBackupInstance.dataSourceInfo = Datasource.fromJson(reader);
                    continue;
                }
                if ("policyInfo".equals(fieldName)) {
                    deserializedBackupInstance.policyInfo = PolicyInfo.fromJson(reader);
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedBackupInstance.objectType = reader.getString();
                    continue;
                }
                if ("friendlyName".equals(fieldName)) {
                    deserializedBackupInstance.friendlyName = reader.getString();
                    continue;
                }
                if ("dataSourceSetInfo".equals(fieldName)) {
                    deserializedBackupInstance.dataSourceSetInfo = DatasourceSet.fromJson(reader);
                    continue;
                }
                if ("resourceGuardOperationRequests".equals(fieldName)) {
                    List resourceGuardOperationRequests;
                    deserializedBackupInstance.resourceGuardOperationRequests = resourceGuardOperationRequests = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("protectionStatus".equals(fieldName)) {
                    deserializedBackupInstance.protectionStatus = ProtectionStatusDetails.fromJson(reader);
                    continue;
                }
                if ("currentProtectionState".equals(fieldName)) {
                    deserializedBackupInstance.currentProtectionState = CurrentProtectionState.fromString(reader.getString());
                    continue;
                }
                if ("protectionErrorDetails".equals(fieldName)) {
                    deserializedBackupInstance.protectionErrorDetails = UserFacingError.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBackupInstance.provisioningState = reader.getString();
                    continue;
                }
                if ("datasourceAuthCredentials".equals(fieldName)) {
                    deserializedBackupInstance.datasourceAuthCredentials = AuthCredentials.fromJson(reader);
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedBackupInstance.validationType = ValidationType.fromString(reader.getString());
                    continue;
                }
                if ("identityDetails".equals(fieldName)) {
                    deserializedBackupInstance.identityDetails = IdentityDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupInstance;
        });
    }
}

