/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BasePolicyRule;
import com.azure.resourcemanager.dataprotection.models.SourceLifeCycle;
import java.io.IOException;
import java.util.List;

public final class AzureRetentionRule
extends BasePolicyRule {
    private String objectType = "AzureRetentionRule";
    private Boolean isDefault;
    private List<SourceLifeCycle> lifecycles;
    private static final ClientLogger LOGGER = new ClientLogger(AzureRetentionRule.class);

    @Override
    public String objectType() {
        return this.objectType;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public AzureRetentionRule withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public List<SourceLifeCycle> lifecycles() {
        return this.lifecycles;
    }

    public AzureRetentionRule withLifecycles(List<SourceLifeCycle> lifecycles) {
        this.lifecycles = lifecycles;
        return this;
    }

    @Override
    public AzureRetentionRule withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        if (this.lifecycles() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property lifecycles in model AzureRetentionRule"));
        }
        this.lifecycles().forEach(e -> e.validate());
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model AzureRetentionRule"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeArrayField("lifecycles", this.lifecycles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        return jsonWriter.writeEndObject();
    }

    public static AzureRetentionRule fromJson(JsonReader jsonReader) throws IOException {
        return (AzureRetentionRule)jsonReader.readObject(reader -> {
            AzureRetentionRule deserializedAzureRetentionRule = new AzureRetentionRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureRetentionRule.withName(reader.getString());
                    continue;
                }
                if ("lifecycles".equals(fieldName)) {
                    List lifecycles;
                    deserializedAzureRetentionRule.lifecycles = lifecycles = reader.readArray(reader1 -> SourceLifeCycle.fromJson(reader1));
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAzureRetentionRule.objectType = reader.getString();
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedAzureRetentionRule.isDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureRetentionRule;
        });
    }
}

