/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.JobExtendedInfo;
import com.azure.resourcemanager.dataprotection.models.UserFacingError;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class AzureBackupJob
implements JsonSerializable<AzureBackupJob> {
    private String activityId;
    private String backupInstanceFriendlyName;
    private String backupInstanceId;
    private String dataSourceId;
    private String dataSourceLocation;
    private String dataSourceName;
    private String dataSourceSetName;
    private String dataSourceType;
    private String duration;
    private OffsetDateTime endTime;
    private List<UserFacingError> errorDetails;
    private JobExtendedInfo extendedInfo;
    private boolean isUserTriggered;
    private String operation;
    private String operationCategory;
    private String policyId;
    private String policyName;
    private boolean progressEnabled;
    private String progressUrl;
    private String rehydrationPriority;
    private String restoreType;
    private String sourceResourceGroup;
    private String sourceSubscriptionId;
    private OffsetDateTime startTime;
    private String status;
    private String subscriptionId;
    private List<String> supportedActions;
    private String vaultName;
    private String etag;
    private String sourceDataStoreName;
    private String destinationDataStoreName;
    private static final ClientLogger LOGGER = new ClientLogger(AzureBackupJob.class);

    public String activityId() {
        return this.activityId;
    }

    public AzureBackupJob withActivityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    public String backupInstanceFriendlyName() {
        return this.backupInstanceFriendlyName;
    }

    public AzureBackupJob withBackupInstanceFriendlyName(String backupInstanceFriendlyName) {
        this.backupInstanceFriendlyName = backupInstanceFriendlyName;
        return this;
    }

    public String backupInstanceId() {
        return this.backupInstanceId;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public AzureBackupJob withDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
        return this;
    }

    public String dataSourceLocation() {
        return this.dataSourceLocation;
    }

    public AzureBackupJob withDataSourceLocation(String dataSourceLocation) {
        this.dataSourceLocation = dataSourceLocation;
        return this;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public AzureBackupJob withDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        return this;
    }

    public String dataSourceSetName() {
        return this.dataSourceSetName;
    }

    public AzureBackupJob withDataSourceSetName(String dataSourceSetName) {
        this.dataSourceSetName = dataSourceSetName;
        return this;
    }

    public String dataSourceType() {
        return this.dataSourceType;
    }

    public AzureBackupJob withDataSourceType(String dataSourceType) {
        this.dataSourceType = dataSourceType;
        return this;
    }

    public String duration() {
        return this.duration;
    }

    public AzureBackupJob withDuration(String duration) {
        this.duration = duration;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public List<UserFacingError> errorDetails() {
        return this.errorDetails;
    }

    public JobExtendedInfo extendedInfo() {
        return this.extendedInfo;
    }

    public boolean isUserTriggered() {
        return this.isUserTriggered;
    }

    public AzureBackupJob withIsUserTriggered(boolean isUserTriggered) {
        this.isUserTriggered = isUserTriggered;
        return this;
    }

    public String operation() {
        return this.operation;
    }

    public AzureBackupJob withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public String operationCategory() {
        return this.operationCategory;
    }

    public AzureBackupJob withOperationCategory(String operationCategory) {
        this.operationCategory = operationCategory;
        return this;
    }

    public String policyId() {
        return this.policyId;
    }

    public String policyName() {
        return this.policyName;
    }

    public boolean progressEnabled() {
        return this.progressEnabled;
    }

    public AzureBackupJob withProgressEnabled(boolean progressEnabled) {
        this.progressEnabled = progressEnabled;
        return this;
    }

    public String progressUrl() {
        return this.progressUrl;
    }

    public String rehydrationPriority() {
        return this.rehydrationPriority;
    }

    public String restoreType() {
        return this.restoreType;
    }

    public String sourceResourceGroup() {
        return this.sourceResourceGroup;
    }

    public AzureBackupJob withSourceResourceGroup(String sourceResourceGroup) {
        this.sourceResourceGroup = sourceResourceGroup;
        return this;
    }

    public String sourceSubscriptionId() {
        return this.sourceSubscriptionId;
    }

    public AzureBackupJob withSourceSubscriptionId(String sourceSubscriptionId) {
        this.sourceSubscriptionId = sourceSubscriptionId;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public AzureBackupJob withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public String status() {
        return this.status;
    }

    public AzureBackupJob withStatus(String status) {
        this.status = status;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public AzureBackupJob withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public List<String> supportedActions() {
        return this.supportedActions;
    }

    public AzureBackupJob withSupportedActions(List<String> supportedActions) {
        this.supportedActions = supportedActions;
        return this;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public AzureBackupJob withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public AzureBackupJob withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public String sourceDataStoreName() {
        return this.sourceDataStoreName;
    }

    public AzureBackupJob withSourceDataStoreName(String sourceDataStoreName) {
        this.sourceDataStoreName = sourceDataStoreName;
        return this;
    }

    public String destinationDataStoreName() {
        return this.destinationDataStoreName;
    }

    public AzureBackupJob withDestinationDataStoreName(String destinationDataStoreName) {
        this.destinationDataStoreName = destinationDataStoreName;
        return this;
    }

    public void validate() {
        if (this.activityId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property activityId in model AzureBackupJob"));
        }
        if (this.backupInstanceFriendlyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupInstanceFriendlyName in model AzureBackupJob"));
        }
        if (this.dataSourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataSourceId in model AzureBackupJob"));
        }
        if (this.dataSourceLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataSourceLocation in model AzureBackupJob"));
        }
        if (this.dataSourceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataSourceName in model AzureBackupJob"));
        }
        if (this.dataSourceType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataSourceType in model AzureBackupJob"));
        }
        if (this.errorDetails() != null) {
            this.errorDetails().forEach(e -> e.validate());
        }
        if (this.extendedInfo() != null) {
            this.extendedInfo().validate();
        }
        if (this.operation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operation in model AzureBackupJob"));
        }
        if (this.operationCategory() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operationCategory in model AzureBackupJob"));
        }
        if (this.sourceResourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceResourceGroup in model AzureBackupJob"));
        }
        if (this.sourceSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceSubscriptionId in model AzureBackupJob"));
        }
        if (this.startTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startTime in model AzureBackupJob"));
        }
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model AzureBackupJob"));
        }
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model AzureBackupJob"));
        }
        if (this.supportedActions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property supportedActions in model AzureBackupJob"));
        }
        if (this.vaultName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vaultName in model AzureBackupJob"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("activityID", this.activityId);
        jsonWriter.writeStringField("backupInstanceFriendlyName", this.backupInstanceFriendlyName);
        jsonWriter.writeStringField("dataSourceId", this.dataSourceId);
        jsonWriter.writeStringField("dataSourceLocation", this.dataSourceLocation);
        jsonWriter.writeStringField("dataSourceName", this.dataSourceName);
        jsonWriter.writeStringField("dataSourceType", this.dataSourceType);
        jsonWriter.writeBooleanField("isUserTriggered", this.isUserTriggered);
        jsonWriter.writeStringField("operation", this.operation);
        jsonWriter.writeStringField("operationCategory", this.operationCategory);
        jsonWriter.writeBooleanField("progressEnabled", this.progressEnabled);
        jsonWriter.writeStringField("sourceResourceGroup", this.sourceResourceGroup);
        jsonWriter.writeStringField("sourceSubscriptionID", this.sourceSubscriptionId);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeArrayField("supportedActions", this.supportedActions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("vaultName", this.vaultName);
        jsonWriter.writeStringField("dataSourceSetName", this.dataSourceSetName);
        jsonWriter.writeStringField("duration", this.duration);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeStringField("sourceDataStoreName", this.sourceDataStoreName);
        jsonWriter.writeStringField("destinationDataStoreName", this.destinationDataStoreName);
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupJob fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupJob)jsonReader.readObject(reader -> {
            AzureBackupJob deserializedAzureBackupJob = new AzureBackupJob();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("activityID".equals(fieldName)) {
                    deserializedAzureBackupJob.activityId = reader.getString();
                    continue;
                }
                if ("backupInstanceFriendlyName".equals(fieldName)) {
                    deserializedAzureBackupJob.backupInstanceFriendlyName = reader.getString();
                    continue;
                }
                if ("dataSourceId".equals(fieldName)) {
                    deserializedAzureBackupJob.dataSourceId = reader.getString();
                    continue;
                }
                if ("dataSourceLocation".equals(fieldName)) {
                    deserializedAzureBackupJob.dataSourceLocation = reader.getString();
                    continue;
                }
                if ("dataSourceName".equals(fieldName)) {
                    deserializedAzureBackupJob.dataSourceName = reader.getString();
                    continue;
                }
                if ("dataSourceType".equals(fieldName)) {
                    deserializedAzureBackupJob.dataSourceType = reader.getString();
                    continue;
                }
                if ("isUserTriggered".equals(fieldName)) {
                    deserializedAzureBackupJob.isUserTriggered = reader.getBoolean();
                    continue;
                }
                if ("operation".equals(fieldName)) {
                    deserializedAzureBackupJob.operation = reader.getString();
                    continue;
                }
                if ("operationCategory".equals(fieldName)) {
                    deserializedAzureBackupJob.operationCategory = reader.getString();
                    continue;
                }
                if ("progressEnabled".equals(fieldName)) {
                    deserializedAzureBackupJob.progressEnabled = reader.getBoolean();
                    continue;
                }
                if ("sourceResourceGroup".equals(fieldName)) {
                    deserializedAzureBackupJob.sourceResourceGroup = reader.getString();
                    continue;
                }
                if ("sourceSubscriptionID".equals(fieldName)) {
                    deserializedAzureBackupJob.sourceSubscriptionId = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedAzureBackupJob.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAzureBackupJob.status = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedAzureBackupJob.subscriptionId = reader.getString();
                    continue;
                }
                if ("supportedActions".equals(fieldName)) {
                    List supportedActions;
                    deserializedAzureBackupJob.supportedActions = supportedActions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("vaultName".equals(fieldName)) {
                    deserializedAzureBackupJob.vaultName = reader.getString();
                    continue;
                }
                if ("backupInstanceId".equals(fieldName)) {
                    deserializedAzureBackupJob.backupInstanceId = reader.getString();
                    continue;
                }
                if ("dataSourceSetName".equals(fieldName)) {
                    deserializedAzureBackupJob.dataSourceSetName = reader.getString();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedAzureBackupJob.duration = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedAzureBackupJob.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    List errorDetails;
                    deserializedAzureBackupJob.errorDetails = errorDetails = reader.readArray(reader1 -> UserFacingError.fromJson(reader1));
                    continue;
                }
                if ("extendedInfo".equals(fieldName)) {
                    deserializedAzureBackupJob.extendedInfo = JobExtendedInfo.fromJson(reader);
                    continue;
                }
                if ("policyId".equals(fieldName)) {
                    deserializedAzureBackupJob.policyId = reader.getString();
                    continue;
                }
                if ("policyName".equals(fieldName)) {
                    deserializedAzureBackupJob.policyName = reader.getString();
                    continue;
                }
                if ("progressUrl".equals(fieldName)) {
                    deserializedAzureBackupJob.progressUrl = reader.getString();
                    continue;
                }
                if ("rehydrationPriority".equals(fieldName)) {
                    deserializedAzureBackupJob.rehydrationPriority = reader.getString();
                    continue;
                }
                if ("restoreType".equals(fieldName)) {
                    deserializedAzureBackupJob.restoreType = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedAzureBackupJob.etag = reader.getString();
                    continue;
                }
                if ("sourceDataStoreName".equals(fieldName)) {
                    deserializedAzureBackupJob.sourceDataStoreName = reader.getString();
                    continue;
                }
                if ("destinationDataStoreName".equals(fieldName)) {
                    deserializedAzureBackupJob.destinationDataStoreName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupJob;
        });
    }
}

