/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.RestoreSourceDataStoreType;
import java.io.IOException;

public final class AzureBackupFindRestorableTimeRangesRequest
implements JsonSerializable<AzureBackupFindRestorableTimeRangesRequest> {
    private RestoreSourceDataStoreType sourceDataStoreType;
    private String startTime;
    private String endTime;
    private static final ClientLogger LOGGER = new ClientLogger(AzureBackupFindRestorableTimeRangesRequest.class);

    public RestoreSourceDataStoreType sourceDataStoreType() {
        return this.sourceDataStoreType;
    }

    public AzureBackupFindRestorableTimeRangesRequest withSourceDataStoreType(RestoreSourceDataStoreType sourceDataStoreType) {
        this.sourceDataStoreType = sourceDataStoreType;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public AzureBackupFindRestorableTimeRangesRequest withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String endTime() {
        return this.endTime;
    }

    public AzureBackupFindRestorableTimeRangesRequest withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public void validate() {
        if (this.sourceDataStoreType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceDataStoreType in model AzureBackupFindRestorableTimeRangesRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceDataStoreType", this.sourceDataStoreType == null ? null : this.sourceDataStoreType.toString());
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupFindRestorableTimeRangesRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupFindRestorableTimeRangesRequest)jsonReader.readObject(reader -> {
            AzureBackupFindRestorableTimeRangesRequest deserializedAzureBackupFindRestorableTimeRangesRequest = new AzureBackupFindRestorableTimeRangesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceDataStoreType".equals(fieldName)) {
                    deserializedAzureBackupFindRestorableTimeRangesRequest.sourceDataStoreType = RestoreSourceDataStoreType.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedAzureBackupFindRestorableTimeRangesRequest.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedAzureBackupFindRestorableTimeRangesRequest.endTime = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupFindRestorableTimeRangesRequest;
        });
    }
}

