/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BlobBackupDatasourceParameters;
import java.io.IOException;
import java.util.List;

public final class AdlsBlobBackupDatasourceParameters
extends BlobBackupDatasourceParameters {
    private String objectType = "AdlsBlobBackupDatasourceParameters";
    private static final ClientLogger LOGGER = new ClientLogger(AdlsBlobBackupDatasourceParameters.class);

    @Override
    public String objectType() {
        return this.objectType;
    }

    @Override
    public AdlsBlobBackupDatasourceParameters withContainersList(List<String> containersList) {
        super.withContainersList(containersList);
        return this;
    }

    @Override
    public void validate() {
        if (this.containersList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property containersList in model AdlsBlobBackupDatasourceParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containersList", this.containersList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static AdlsBlobBackupDatasourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AdlsBlobBackupDatasourceParameters)jsonReader.readObject(reader -> {
            AdlsBlobBackupDatasourceParameters deserializedAdlsBlobBackupDatasourceParameters = new AdlsBlobBackupDatasourceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containersList".equals(fieldName)) {
                    List containersList = reader.readArray(reader1 -> reader1.getString());
                    deserializedAdlsBlobBackupDatasourceParameters.withContainersList(containersList);
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAdlsBlobBackupDatasourceParameters.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdlsBlobBackupDatasourceParameters;
        });
    }
}

