/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AdhocBackupTriggerOption;
import java.io.IOException;

public final class AdHocBackupRuleOptions
implements JsonSerializable<AdHocBackupRuleOptions> {
    private String ruleName;
    private AdhocBackupTriggerOption triggerOption;
    private static final ClientLogger LOGGER = new ClientLogger(AdHocBackupRuleOptions.class);

    public String ruleName() {
        return this.ruleName;
    }

    public AdHocBackupRuleOptions withRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    public AdhocBackupTriggerOption triggerOption() {
        return this.triggerOption;
    }

    public AdHocBackupRuleOptions withTriggerOption(AdhocBackupTriggerOption triggerOption) {
        this.triggerOption = triggerOption;
        return this;
    }

    public void validate() {
        if (this.ruleName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleName in model AdHocBackupRuleOptions"));
        }
        if (this.triggerOption() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property triggerOption in model AdHocBackupRuleOptions"));
        }
        this.triggerOption().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleName", this.ruleName);
        jsonWriter.writeJsonField("triggerOption", (JsonSerializable)this.triggerOption);
        return jsonWriter.writeEndObject();
    }

    public static AdHocBackupRuleOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AdHocBackupRuleOptions)jsonReader.readObject(reader -> {
            AdHocBackupRuleOptions deserializedAdHocBackupRuleOptions = new AdHocBackupRuleOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleName".equals(fieldName)) {
                    deserializedAdHocBackupRuleOptions.ruleName = reader.getString();
                    continue;
                }
                if ("triggerOption".equals(fieldName)) {
                    deserializedAdHocBackupRuleOptions.triggerOption = AdhocBackupTriggerOption.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdHocBackupRuleOptions;
        });
    }
}

