/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.DeleteOption;
import java.io.IOException;

public final class AbsoluteDeleteOption
extends DeleteOption {
    private String objectType = "AbsoluteDeleteOption";
    private static final ClientLogger LOGGER = new ClientLogger(AbsoluteDeleteOption.class);

    @Override
    public String objectType() {
        return this.objectType;
    }

    @Override
    public AbsoluteDeleteOption withDuration(String duration) {
        super.withDuration(duration);
        return this;
    }

    @Override
    public void validate() {
        if (this.duration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property duration in model AbsoluteDeleteOption"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("duration", this.duration());
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static AbsoluteDeleteOption fromJson(JsonReader jsonReader) throws IOException {
        return (AbsoluteDeleteOption)jsonReader.readObject(reader -> {
            AbsoluteDeleteOption deserializedAbsoluteDeleteOption = new AbsoluteDeleteOption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("duration".equals(fieldName)) {
                    deserializedAbsoluteDeleteOption.withDuration(reader.getString());
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAbsoluteDeleteOption.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAbsoluteDeleteOption;
        });
    }
}

