/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.RestorableTimeRangesClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupFindRestorableTimeRangesResponseResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.AzureBackupFindRestorableTimeRangesResponseResourceImpl;
import com.azure.resourcemanager.dataprotection.models.AzureBackupFindRestorableTimeRangesRequest;
import com.azure.resourcemanager.dataprotection.models.AzureBackupFindRestorableTimeRangesResponseResource;
import com.azure.resourcemanager.dataprotection.models.RestorableTimeRanges;

public final class RestorableTimeRangesImpl
implements RestorableTimeRanges {
    private static final ClientLogger LOGGER = new ClientLogger(RestorableTimeRangesImpl.class);
    private final RestorableTimeRangesClient innerClient;
    private final DataProtectionManager serviceManager;

    public RestorableTimeRangesImpl(RestorableTimeRangesClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AzureBackupFindRestorableTimeRangesResponseResource> findWithResponse(String resourceGroupName, String vaultName, String backupInstanceName, AzureBackupFindRestorableTimeRangesRequest parameters, Context context) {
        Response<AzureBackupFindRestorableTimeRangesResponseResourceInner> inner = this.serviceClient().findWithResponse(resourceGroupName, vaultName, backupInstanceName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureBackupFindRestorableTimeRangesResponseResourceImpl((AzureBackupFindRestorableTimeRangesResponseResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AzureBackupFindRestorableTimeRangesResponseResource find(String resourceGroupName, String vaultName, String backupInstanceName, AzureBackupFindRestorableTimeRangesRequest parameters) {
        AzureBackupFindRestorableTimeRangesResponseResourceInner inner = this.serviceClient().find(resourceGroupName, vaultName, backupInstanceName, parameters);
        if (inner != null) {
            return new AzureBackupFindRestorableTimeRangesResponseResourceImpl(inner, this.manager());
        }
        return null;
    }

    private RestorableTimeRangesClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

