/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.models.ResourceGuardResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.PatchResourceGuardInput;
import com.azure.resourcemanager.dataprotection.models.ResourceGuard;
import com.azure.resourcemanager.dataprotection.models.ResourceGuardResource;
import java.util.Collections;
import java.util.Map;

public final class ResourceGuardResourceImpl
implements ResourceGuardResource,
ResourceGuardResource.Definition,
ResourceGuardResource.Update {
    private ResourceGuardResourceInner innerObject;
    private final DataProtectionManager serviceManager;
    private String resourceGroupName;
    private String resourceGuardsName;
    private PatchResourceGuardInput updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ResourceGuard properties() {
        return this.innerModel().properties();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ResourceGuardResourceInner innerModel() {
        return this.innerObject;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public ResourceGuardResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ResourceGuardResource create() {
        this.innerObject = (ResourceGuardResourceInner)((Object)this.serviceManager.serviceClient().getResourceGuards().putWithResponse(this.resourceGroupName, this.resourceGuardsName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ResourceGuardResource create(Context context) {
        this.innerObject = (ResourceGuardResourceInner)((Object)this.serviceManager.serviceClient().getResourceGuards().putWithResponse(this.resourceGroupName, this.resourceGuardsName, this.innerModel(), context).getValue());
        return this;
    }

    ResourceGuardResourceImpl(String name, DataProtectionManager serviceManager) {
        this.innerObject = new ResourceGuardResourceInner();
        this.serviceManager = serviceManager;
        this.resourceGuardsName = name;
    }

    @Override
    public ResourceGuardResourceImpl update() {
        this.updateParameters = new PatchResourceGuardInput();
        return this;
    }

    @Override
    public ResourceGuardResource apply() {
        this.innerObject = (ResourceGuardResourceInner)((Object)this.serviceManager.serviceClient().getResourceGuards().patchWithResponse(this.resourceGroupName, this.resourceGuardsName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public ResourceGuardResource apply(Context context) {
        this.innerObject = (ResourceGuardResourceInner)((Object)this.serviceManager.serviceClient().getResourceGuards().patchWithResponse(this.resourceGroupName, this.resourceGuardsName, this.updateParameters, context).getValue());
        return this;
    }

    ResourceGuardResourceImpl(ResourceGuardResourceInner innerObject, DataProtectionManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceGuardsName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGuards");
    }

    @Override
    public ResourceGuardResource refresh() {
        this.innerObject = (ResourceGuardResourceInner)((Object)this.serviceManager.serviceClient().getResourceGuards().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceGuardsName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ResourceGuardResource refresh(Context context) {
        this.innerObject = (ResourceGuardResourceInner)((Object)this.serviceManager.serviceClient().getResourceGuards().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceGuardsName, context).getValue());
        return this;
    }

    @Override
    public ResourceGuardResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ResourceGuardResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ResourceGuardResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ResourceGuardResourceImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public ResourceGuardResourceImpl withProperties(ResourceGuard properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

