/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.models.ResourceGuardProxyBaseResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.ResourceGuardProxyBase;
import com.azure.resourcemanager.dataprotection.models.ResourceGuardProxyBaseResource;
import com.azure.resourcemanager.dataprotection.models.UnlockDeleteRequest;
import com.azure.resourcemanager.dataprotection.models.UnlockDeleteResponse;

public final class ResourceGuardProxyBaseResourceImpl
implements ResourceGuardProxyBaseResource,
ResourceGuardProxyBaseResource.Definition,
ResourceGuardProxyBaseResource.Update {
    private ResourceGuardProxyBaseResourceInner innerObject;
    private final DataProtectionManager serviceManager;
    private String resourceGroupName;
    private String vaultName;
    private String resourceGuardProxyName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ResourceGuardProxyBase properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ResourceGuardProxyBaseResourceInner innerModel() {
        return this.innerObject;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public ResourceGuardProxyBaseResourceImpl withExistingBackupVault(String resourceGroupName, String vaultName) {
        this.resourceGroupName = resourceGroupName;
        this.vaultName = vaultName;
        return this;
    }

    @Override
    public ResourceGuardProxyBaseResource create() {
        this.innerObject = (ResourceGuardProxyBaseResourceInner)((Object)this.serviceManager.serviceClient().getDppResourceGuardProxies().createOrUpdateWithResponse(this.resourceGroupName, this.vaultName, this.resourceGuardProxyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ResourceGuardProxyBaseResource create(Context context) {
        this.innerObject = (ResourceGuardProxyBaseResourceInner)((Object)this.serviceManager.serviceClient().getDppResourceGuardProxies().createOrUpdateWithResponse(this.resourceGroupName, this.vaultName, this.resourceGuardProxyName, this.innerModel(), context).getValue());
        return this;
    }

    ResourceGuardProxyBaseResourceImpl(String name, DataProtectionManager serviceManager) {
        this.innerObject = new ResourceGuardProxyBaseResourceInner();
        this.serviceManager = serviceManager;
        this.resourceGuardProxyName = name;
    }

    @Override
    public ResourceGuardProxyBaseResourceImpl update() {
        return this;
    }

    @Override
    public ResourceGuardProxyBaseResource apply() {
        this.innerObject = (ResourceGuardProxyBaseResourceInner)((Object)this.serviceManager.serviceClient().getDppResourceGuardProxies().createOrUpdateWithResponse(this.resourceGroupName, this.vaultName, this.resourceGuardProxyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ResourceGuardProxyBaseResource apply(Context context) {
        this.innerObject = (ResourceGuardProxyBaseResourceInner)((Object)this.serviceManager.serviceClient().getDppResourceGuardProxies().createOrUpdateWithResponse(this.resourceGroupName, this.vaultName, this.resourceGuardProxyName, this.innerModel(), context).getValue());
        return this;
    }

    ResourceGuardProxyBaseResourceImpl(ResourceGuardProxyBaseResourceInner innerObject, DataProtectionManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.vaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupVaults");
        this.resourceGuardProxyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupResourceGuardProxies");
    }

    @Override
    public ResourceGuardProxyBaseResource refresh() {
        this.innerObject = (ResourceGuardProxyBaseResourceInner)((Object)this.serviceManager.serviceClient().getDppResourceGuardProxies().getWithResponse(this.resourceGroupName, this.vaultName, this.resourceGuardProxyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ResourceGuardProxyBaseResource refresh(Context context) {
        this.innerObject = (ResourceGuardProxyBaseResourceInner)((Object)this.serviceManager.serviceClient().getDppResourceGuardProxies().getWithResponse(this.resourceGroupName, this.vaultName, this.resourceGuardProxyName, context).getValue());
        return this;
    }

    @Override
    public Response<UnlockDeleteResponse> unlockDeleteWithResponse(UnlockDeleteRequest parameters, Context context) {
        return this.serviceManager.dppResourceGuardProxies().unlockDeleteWithResponse(this.resourceGroupName, this.vaultName, this.resourceGuardProxyName, parameters, context);
    }

    @Override
    public UnlockDeleteResponse unlockDelete(UnlockDeleteRequest parameters) {
        return this.serviceManager.dppResourceGuardProxies().unlockDelete(this.resourceGroupName, this.vaultName, this.resourceGuardProxyName, parameters);
    }

    @Override
    public ResourceGuardProxyBaseResourceImpl withProperties(ResourceGuardProxyBase properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

