/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.FetchCrossRegionRestoreJobsOperationsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupJobResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.AzureBackupJobResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.AzureBackupJobResource;
import com.azure.resourcemanager.dataprotection.models.CrossRegionRestoreJobsRequest;
import com.azure.resourcemanager.dataprotection.models.FetchCrossRegionRestoreJobsOperations;

public final class FetchCrossRegionRestoreJobsOperationsImpl
implements FetchCrossRegionRestoreJobsOperations {
    private static final ClientLogger LOGGER = new ClientLogger(FetchCrossRegionRestoreJobsOperationsImpl.class);
    private final FetchCrossRegionRestoreJobsOperationsClient innerClient;
    private final DataProtectionManager serviceManager;

    public FetchCrossRegionRestoreJobsOperationsImpl(FetchCrossRegionRestoreJobsOperationsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AzureBackupJobResource> list(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters) {
        PagedIterable<AzureBackupJobResourceInner> inner = this.serviceClient().list(resourceGroupName, location, parameters);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureBackupJobResourceImpl((AzureBackupJobResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AzureBackupJobResource> list(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters, String filter, Context context) {
        PagedIterable<AzureBackupJobResourceInner> inner = this.serviceClient().list(resourceGroupName, location, parameters, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureBackupJobResourceImpl((AzureBackupJobResourceInner)((Object)inner1), this.manager()));
    }

    private FetchCrossRegionRestoreJobsOperationsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

