/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.DppResourceGuardProxiesClient;
import com.azure.resourcemanager.dataprotection.fluent.models.ResourceGuardProxyBaseResourceInner;
import com.azure.resourcemanager.dataprotection.fluent.models.UnlockDeleteResponseInner;
import com.azure.resourcemanager.dataprotection.implementation.ResourceGuardProxyBaseResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.implementation.UnlockDeleteResponseImpl;
import com.azure.resourcemanager.dataprotection.models.DppResourceGuardProxies;
import com.azure.resourcemanager.dataprotection.models.ResourceGuardProxyBaseResource;
import com.azure.resourcemanager.dataprotection.models.UnlockDeleteRequest;
import com.azure.resourcemanager.dataprotection.models.UnlockDeleteResponse;

public final class DppResourceGuardProxiesImpl
implements DppResourceGuardProxies {
    private static final ClientLogger LOGGER = new ClientLogger(DppResourceGuardProxiesImpl.class);
    private final DppResourceGuardProxiesClient innerClient;
    private final DataProtectionManager serviceManager;

    public DppResourceGuardProxiesImpl(DppResourceGuardProxiesClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ResourceGuardProxyBaseResource> list(String resourceGroupName, String vaultName) {
        PagedIterable<ResourceGuardProxyBaseResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceGuardProxyBaseResourceImpl((ResourceGuardProxyBaseResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ResourceGuardProxyBaseResource> list(String resourceGroupName, String vaultName, Context context) {
        PagedIterable<ResourceGuardProxyBaseResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceGuardProxyBaseResourceImpl((ResourceGuardProxyBaseResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ResourceGuardProxyBaseResource> getWithResponse(String resourceGroupName, String vaultName, String resourceGuardProxyName, Context context) {
        Response<ResourceGuardProxyBaseResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ResourceGuardProxyBaseResourceImpl((ResourceGuardProxyBaseResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ResourceGuardProxyBaseResource get(String resourceGroupName, String vaultName, String resourceGuardProxyName) {
        ResourceGuardProxyBaseResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, resourceGuardProxyName);
        if (inner != null) {
            return new ResourceGuardProxyBaseResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String vaultName, String resourceGuardProxyName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, context);
    }

    @Override
    public void delete(String resourceGroupName, String vaultName, String resourceGuardProxyName) {
        this.serviceClient().delete(resourceGroupName, vaultName, resourceGuardProxyName);
    }

    @Override
    public Response<UnlockDeleteResponse> unlockDeleteWithResponse(String resourceGroupName, String vaultName, String resourceGuardProxyName, UnlockDeleteRequest parameters, Context context) {
        Response<UnlockDeleteResponseInner> inner = this.serviceClient().unlockDeleteWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UnlockDeleteResponseImpl((UnlockDeleteResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public UnlockDeleteResponse unlockDelete(String resourceGroupName, String vaultName, String resourceGuardProxyName, UnlockDeleteRequest parameters) {
        UnlockDeleteResponseInner inner = this.serviceClient().unlockDelete(resourceGroupName, vaultName, resourceGuardProxyName, parameters);
        if (inner != null) {
            return new UnlockDeleteResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ResourceGuardProxyBaseResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String resourceGuardProxyName = ResourceManagerUtils.getValueFromIdByName(id, "backupResourceGuardProxies");
        if (resourceGuardProxyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupResourceGuardProxies'.", id)));
        }
        return (ResourceGuardProxyBaseResource)this.getWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, Context.NONE).getValue();
    }

    @Override
    public Response<ResourceGuardProxyBaseResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String resourceGuardProxyName = ResourceManagerUtils.getValueFromIdByName(id, "backupResourceGuardProxies");
        if (resourceGuardProxyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupResourceGuardProxies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String resourceGuardProxyName = ResourceManagerUtils.getValueFromIdByName(id, "backupResourceGuardProxies");
        if (resourceGuardProxyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupResourceGuardProxies'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String resourceGuardProxyName = ResourceManagerUtils.getValueFromIdByName(id, "backupResourceGuardProxies");
        if (resourceGuardProxyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupResourceGuardProxies'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, context);
    }

    private DppResourceGuardProxiesClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public ResourceGuardProxyBaseResourceImpl define(String name) {
        return new ResourceGuardProxyBaseResourceImpl(name, this.manager());
    }
}

