/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.DataProtectionOperationsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.ClientDiscoveryValueForSingleApiInner;
import com.azure.resourcemanager.dataprotection.implementation.ClientDiscoveryValueForSingleApiImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.ClientDiscoveryValueForSingleApi;
import com.azure.resourcemanager.dataprotection.models.DataProtectionOperations;

public final class DataProtectionOperationsImpl
implements DataProtectionOperations {
    private static final ClientLogger LOGGER = new ClientLogger(DataProtectionOperationsImpl.class);
    private final DataProtectionOperationsClient innerClient;
    private final DataProtectionManager serviceManager;

    public DataProtectionOperationsImpl(DataProtectionOperationsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ClientDiscoveryValueForSingleApi> list() {
        PagedIterable<ClientDiscoveryValueForSingleApiInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientDiscoveryValueForSingleApiImpl((ClientDiscoveryValueForSingleApiInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ClientDiscoveryValueForSingleApi> list(Context context) {
        PagedIterable<ClientDiscoveryValueForSingleApiInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientDiscoveryValueForSingleApiImpl((ClientDiscoveryValueForSingleApiInner)inner1, this.manager()));
    }

    private DataProtectionOperationsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

