/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.dataprotection.fluent.BackupInstancesClient;
import com.azure.resourcemanager.dataprotection.fluent.BackupInstancesExtensionRoutingsClient;
import com.azure.resourcemanager.dataprotection.fluent.BackupPoliciesClient;
import com.azure.resourcemanager.dataprotection.fluent.BackupVaultOperationResultsClient;
import com.azure.resourcemanager.dataprotection.fluent.BackupVaultsClient;
import com.azure.resourcemanager.dataprotection.fluent.DataProtectionClient;
import com.azure.resourcemanager.dataprotection.fluent.DataProtectionOperationsClient;
import com.azure.resourcemanager.dataprotection.fluent.DataProtectionsClient;
import com.azure.resourcemanager.dataprotection.fluent.DeletedBackupInstancesClient;
import com.azure.resourcemanager.dataprotection.fluent.DppResourceGuardProxiesClient;
import com.azure.resourcemanager.dataprotection.fluent.ExportJobsClient;
import com.azure.resourcemanager.dataprotection.fluent.ExportJobsOperationResultsClient;
import com.azure.resourcemanager.dataprotection.fluent.FetchCrossRegionRestoreJobsClient;
import com.azure.resourcemanager.dataprotection.fluent.FetchCrossRegionRestoreJobsOperationsClient;
import com.azure.resourcemanager.dataprotection.fluent.FetchSecondaryRecoveryPointsClient;
import com.azure.resourcemanager.dataprotection.fluent.JobsClient;
import com.azure.resourcemanager.dataprotection.fluent.OperationResultsClient;
import com.azure.resourcemanager.dataprotection.fluent.OperationStatusBackupVaultContextsClient;
import com.azure.resourcemanager.dataprotection.fluent.OperationStatusClient;
import com.azure.resourcemanager.dataprotection.fluent.OperationStatusResourceGroupContextsClient;
import com.azure.resourcemanager.dataprotection.fluent.RecoveryPointsClient;
import com.azure.resourcemanager.dataprotection.fluent.ResourceGuardsClient;
import com.azure.resourcemanager.dataprotection.fluent.RestorableTimeRangesClient;
import com.azure.resourcemanager.dataprotection.implementation.BackupInstancesClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.BackupInstancesExtensionRoutingsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.BackupPoliciesClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.BackupVaultOperationResultsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.BackupVaultsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionClientBuilder;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionOperationsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.DeletedBackupInstancesClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.DppResourceGuardProxiesClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.ExportJobsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.ExportJobsOperationResultsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.FetchCrossRegionRestoreJobsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.FetchCrossRegionRestoreJobsOperationsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.FetchSecondaryRecoveryPointsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.JobsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationResultsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationStatusBackupVaultContextsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationStatusClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationStatusResourceGroupContextsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.RecoveryPointsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceGuardsClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.RestorableTimeRangesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataProtectionClientBuilder.class)
public final class DataProtectionClientImpl
implements DataProtectionClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final BackupVaultsClient backupVaults;
    private final OperationResultsClient operationResults;
    private final OperationStatusClient operationStatus;
    private final OperationStatusBackupVaultContextsClient operationStatusBackupVaultContexts;
    private final OperationStatusResourceGroupContextsClient operationStatusResourceGroupContexts;
    private final BackupVaultOperationResultsClient backupVaultOperationResults;
    private final DataProtectionsClient dataProtections;
    private final DataProtectionOperationsClient dataProtectionOperations;
    private final BackupPoliciesClient backupPolicies;
    private final BackupInstancesClient backupInstances;
    private final RecoveryPointsClient recoveryPoints;
    private final FetchSecondaryRecoveryPointsClient fetchSecondaryRecoveryPoints;
    private final FetchCrossRegionRestoreJobsClient fetchCrossRegionRestoreJobs;
    private final FetchCrossRegionRestoreJobsOperationsClient fetchCrossRegionRestoreJobsOperations;
    private final BackupInstancesExtensionRoutingsClient backupInstancesExtensionRoutings;
    private final JobsClient jobs;
    private final RestorableTimeRangesClient restorableTimeRanges;
    private final ExportJobsClient exportJobs;
    private final ExportJobsOperationResultsClient exportJobsOperationResults;
    private final DeletedBackupInstancesClient deletedBackupInstances;
    private final ResourceGuardsClient resourceGuards;
    private final DppResourceGuardProxiesClient dppResourceGuardProxies;
    private static final ClientLogger LOGGER = new ClientLogger(DataProtectionClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public BackupVaultsClient getBackupVaults() {
        return this.backupVaults;
    }

    @Override
    public OperationResultsClient getOperationResults() {
        return this.operationResults;
    }

    @Override
    public OperationStatusClient getOperationStatus() {
        return this.operationStatus;
    }

    @Override
    public OperationStatusBackupVaultContextsClient getOperationStatusBackupVaultContexts() {
        return this.operationStatusBackupVaultContexts;
    }

    @Override
    public OperationStatusResourceGroupContextsClient getOperationStatusResourceGroupContexts() {
        return this.operationStatusResourceGroupContexts;
    }

    @Override
    public BackupVaultOperationResultsClient getBackupVaultOperationResults() {
        return this.backupVaultOperationResults;
    }

    @Override
    public DataProtectionsClient getDataProtections() {
        return this.dataProtections;
    }

    @Override
    public DataProtectionOperationsClient getDataProtectionOperations() {
        return this.dataProtectionOperations;
    }

    @Override
    public BackupPoliciesClient getBackupPolicies() {
        return this.backupPolicies;
    }

    @Override
    public BackupInstancesClient getBackupInstances() {
        return this.backupInstances;
    }

    @Override
    public RecoveryPointsClient getRecoveryPoints() {
        return this.recoveryPoints;
    }

    @Override
    public FetchSecondaryRecoveryPointsClient getFetchSecondaryRecoveryPoints() {
        return this.fetchSecondaryRecoveryPoints;
    }

    @Override
    public FetchCrossRegionRestoreJobsClient getFetchCrossRegionRestoreJobs() {
        return this.fetchCrossRegionRestoreJobs;
    }

    @Override
    public FetchCrossRegionRestoreJobsOperationsClient getFetchCrossRegionRestoreJobsOperations() {
        return this.fetchCrossRegionRestoreJobsOperations;
    }

    @Override
    public BackupInstancesExtensionRoutingsClient getBackupInstancesExtensionRoutings() {
        return this.backupInstancesExtensionRoutings;
    }

    @Override
    public JobsClient getJobs() {
        return this.jobs;
    }

    @Override
    public RestorableTimeRangesClient getRestorableTimeRanges() {
        return this.restorableTimeRanges;
    }

    @Override
    public ExportJobsClient getExportJobs() {
        return this.exportJobs;
    }

    @Override
    public ExportJobsOperationResultsClient getExportJobsOperationResults() {
        return this.exportJobsOperationResults;
    }

    @Override
    public DeletedBackupInstancesClient getDeletedBackupInstances() {
        return this.deletedBackupInstances;
    }

    @Override
    public ResourceGuardsClient getResourceGuards() {
        return this.resourceGuards;
    }

    @Override
    public DppResourceGuardProxiesClient getDppResourceGuardProxies() {
        return this.dppResourceGuardProxies;
    }

    DataProtectionClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-07-01";
        this.backupVaults = new BackupVaultsClientImpl(this);
        this.operationResults = new OperationResultsClientImpl(this);
        this.operationStatus = new OperationStatusClientImpl(this);
        this.operationStatusBackupVaultContexts = new OperationStatusBackupVaultContextsClientImpl(this);
        this.operationStatusResourceGroupContexts = new OperationStatusResourceGroupContextsClientImpl(this);
        this.backupVaultOperationResults = new BackupVaultOperationResultsClientImpl(this);
        this.dataProtections = new DataProtectionsClientImpl(this);
        this.dataProtectionOperations = new DataProtectionOperationsClientImpl(this);
        this.backupPolicies = new BackupPoliciesClientImpl(this);
        this.backupInstances = new BackupInstancesClientImpl(this);
        this.recoveryPoints = new RecoveryPointsClientImpl(this);
        this.fetchSecondaryRecoveryPoints = new FetchSecondaryRecoveryPointsClientImpl(this);
        this.fetchCrossRegionRestoreJobs = new FetchCrossRegionRestoreJobsClientImpl(this);
        this.fetchCrossRegionRestoreJobsOperations = new FetchCrossRegionRestoreJobsOperationsClientImpl(this);
        this.backupInstancesExtensionRoutings = new BackupInstancesExtensionRoutingsClientImpl(this);
        this.jobs = new JobsClientImpl(this);
        this.restorableTimeRanges = new RestorableTimeRangesClientImpl(this);
        this.exportJobs = new ExportJobsClientImpl(this);
        this.exportJobsOperationResults = new ExportJobsOperationResultsClientImpl(this);
        this.deletedBackupInstances = new DeletedBackupInstancesClientImpl(this);
        this.resourceGuards = new ResourceGuardsClientImpl(this);
        this.dppResourceGuardProxies = new DppResourceGuardProxiesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

