/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.BackupVaultOperationResultsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupVaultResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.BackupVaultResourceImpl;
import com.azure.resourcemanager.dataprotection.models.BackupVaultOperationResults;
import com.azure.resourcemanager.dataprotection.models.BackupVaultOperationResultsGetResponse;
import com.azure.resourcemanager.dataprotection.models.BackupVaultResource;

public final class BackupVaultOperationResultsImpl
implements BackupVaultOperationResults {
    private static final ClientLogger LOGGER = new ClientLogger(BackupVaultOperationResultsImpl.class);
    private final BackupVaultOperationResultsClient innerClient;
    private final DataProtectionManager serviceManager;

    public BackupVaultOperationResultsImpl(BackupVaultOperationResultsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BackupVaultResource> getWithResponse(String resourceGroupName, String vaultName, String operationId, Context context) {
        BackupVaultOperationResultsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupVaultResourceImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BackupVaultResource get(String resourceGroupName, String vaultName, String operationId) {
        BackupVaultResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, operationId);
        if (inner != null) {
            return new BackupVaultResourceImpl(inner, this.manager());
        }
        return null;
    }

    private BackupVaultOperationResultsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

