/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.BackupPoliciesClient;
import com.azure.resourcemanager.dataprotection.fluent.models.BaseBackupPolicyResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.BaseBackupPolicyResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.BackupPolicies;
import com.azure.resourcemanager.dataprotection.models.BaseBackupPolicyResource;

public final class BackupPoliciesImpl
implements BackupPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(BackupPoliciesImpl.class);
    private final BackupPoliciesClient innerClient;
    private final DataProtectionManager serviceManager;

    public BackupPoliciesImpl(BackupPoliciesClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BaseBackupPolicyResource> list(String resourceGroupName, String vaultName) {
        PagedIterable<BaseBackupPolicyResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BaseBackupPolicyResourceImpl((BaseBackupPolicyResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BaseBackupPolicyResource> list(String resourceGroupName, String vaultName, Context context) {
        PagedIterable<BaseBackupPolicyResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BaseBackupPolicyResourceImpl((BaseBackupPolicyResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<BaseBackupPolicyResource> getWithResponse(String resourceGroupName, String vaultName, String backupPolicyName, Context context) {
        Response<BaseBackupPolicyResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, backupPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BaseBackupPolicyResourceImpl((BaseBackupPolicyResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BaseBackupPolicyResource get(String resourceGroupName, String vaultName, String backupPolicyName) {
        BaseBackupPolicyResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, backupPolicyName);
        if (inner != null) {
            return new BaseBackupPolicyResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String vaultName, String backupPolicyName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, vaultName, backupPolicyName, context);
    }

    @Override
    public void delete(String resourceGroupName, String vaultName, String backupPolicyName) {
        this.serviceClient().delete(resourceGroupName, vaultName, backupPolicyName);
    }

    @Override
    public BaseBackupPolicyResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "backupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupPolicies'.", id)));
        }
        return (BaseBackupPolicyResource)this.getWithResponse(resourceGroupName, vaultName, backupPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<BaseBackupPolicyResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "backupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, vaultName, backupPolicyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "backupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupPolicies'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, vaultName, backupPolicyName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "backupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupPolicies'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, vaultName, backupPolicyName, context);
    }

    private BackupPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public BaseBackupPolicyResourceImpl define(String name) {
        return new BaseBackupPolicyResourceImpl(name, this.manager());
    }
}

