/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbSyncDatabaseInput;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class ValidateSyncMigrationInputSqlServerTaskInput
implements JsonSerializable<ValidateSyncMigrationInputSqlServerTaskInput> {
    private SqlConnectionInfo sourceConnectionInfo;
    private SqlConnectionInfo targetConnectionInfo;
    private List<MigrateSqlServerSqlDbSyncDatabaseInput> selectedDatabases;
    private static final ClientLogger LOGGER = new ClientLogger(ValidateSyncMigrationInputSqlServerTaskInput.class);

    public SqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public ValidateSyncMigrationInputSqlServerTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public SqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public ValidateSyncMigrationInputSqlServerTaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public List<MigrateSqlServerSqlDbSyncDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public ValidateSyncMigrationInputSqlServerTaskInput withSelectedDatabases(List<MigrateSqlServerSqlDbSyncDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model ValidateSyncMigrationInputSqlServerTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model ValidateSyncMigrationInputSqlServerTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model ValidateSyncMigrationInputSqlServerTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ValidateSyncMigrationInputSqlServerTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ValidateSyncMigrationInputSqlServerTaskInput)jsonReader.readObject(reader -> {
            ValidateSyncMigrationInputSqlServerTaskInput deserializedValidateSyncMigrationInputSqlServerTaskInput = new ValidateSyncMigrationInputSqlServerTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedValidateSyncMigrationInputSqlServerTaskInput.sourceConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedValidateSyncMigrationInputSqlServerTaskInput.targetConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedValidateSyncMigrationInputSqlServerTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateSqlServerSqlDbSyncDatabaseInput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateSyncMigrationInputSqlServerTaskInput;
        });
    }
}

