/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import com.azure.resourcemanager.datamigration.models.ValidateMigrationInputSqlServerSqlMITaskInput;
import com.azure.resourcemanager.datamigration.models.ValidateMigrationInputSqlServerSqlMITaskOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ValidateMigrationInputSqlServerSqlMITaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.VALIDATE_MIGRATION_INPUT_SQL_SERVER_AZURE_SQL_DB_MI;
    private ValidateMigrationInputSqlServerSqlMITaskInput input;
    private List<ValidateMigrationInputSqlServerSqlMITaskOutput> output;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public ValidateMigrationInputSqlServerSqlMITaskInput input() {
        return this.input;
    }

    public ValidateMigrationInputSqlServerSqlMITaskProperties withInput(ValidateMigrationInputSqlServerSqlMITaskInput input) {
        this.input = input;
        return this;
    }

    public List<ValidateMigrationInputSqlServerSqlMITaskOutput> output() {
        return this.output;
    }

    @Override
    public ValidateMigrationInputSqlServerSqlMITaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        return jsonWriter.writeEndObject();
    }

    public static ValidateMigrationInputSqlServerSqlMITaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ValidateMigrationInputSqlServerSqlMITaskProperties)jsonReader.readObject(reader -> {
            ValidateMigrationInputSqlServerSqlMITaskProperties deserializedValidateMigrationInputSqlServerSqlMITaskProperties = new ValidateMigrationInputSqlServerSqlMITaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedValidateMigrationInputSqlServerSqlMITaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedValidateMigrationInputSqlServerSqlMITaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedValidateMigrationInputSqlServerSqlMITaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskProperties.input = ValidateMigrationInputSqlServerSqlMITaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedValidateMigrationInputSqlServerSqlMITaskProperties.output = output = reader.readArray(reader1 -> ValidateMigrationInputSqlServerSqlMITaskOutput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateMigrationInputSqlServerSqlMITaskProperties;
        });
    }
}

