/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectTaskInner;
import java.io.IOException;
import java.util.List;

public final class TaskList
implements JsonSerializable<TaskList> {
    private List<ProjectTaskInner> value;
    private String nextLink;

    public List<ProjectTaskInner> value() {
        return this.value;
    }

    public TaskList withValue(List<ProjectTaskInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public TaskList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static TaskList fromJson(JsonReader jsonReader) throws IOException {
        return (TaskList)jsonReader.readObject(reader -> {
            TaskList deserializedTaskList = new TaskList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTaskList.value = value = reader.readArray(reader1 -> ProjectTaskInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedTaskList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskList;
        });
    }
}

